/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.certificate;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.uploader.FileResourceEnum;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFileParameter;
import cn.smarthse.radiationTraining.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.Certificate;
import cn.smarthse.radiationTraining.modules.training.param.CertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ICertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertificateVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=40, author="\u5434\u5c0f\u5f3a")
@Api(tags={"\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/certificate"})
public class CertificateController
extends ControllerSupport {
    private final String info_prefix = "[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]";
    @DubboReference
    private ICertificateProviderService certificateProviderService;
    private static final String UPLOADDIR = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();

    @RequiresPermissions(value={"cert:view"})
    @ApiOperation(value="\u8bc1\u4e66\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"getList"})
    public ResponseData<LayuiGridData<CertificateVo>> getList(PageParam param) {
        this.logger.debug("{}-\u67e5\u8be2\u8bc1\u4e66\u6a21\u677f\u5217\u8868", (Object)"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]");
        return new ResponseData((Object)this.certificateProviderService.getCertificateList(param));
    }

    @RequiresPermissions(value={"cert:view"})
    @ApiOperation(value="\u67e5\u770b\u8bc1\u4e66\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bc1\u4e66id")})
    @GetMapping(value={"getPaperStructureDetail"})
    public ResponseData<Certificate> getQuestionDetail(Long id) {
        this.logger.debug("{}-\u67e5\u770b\u8bc1\u4e66\u8be6\u60c5\uff1aid-{}", (Object)"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]", (Object)id);
        return ResponseData.success((Object)this.certificateProviderService.getCertificateDetailById(id));
    }

    @RequiresPermissions(value={"cert:edit"})
    @ApiOperation(value="\u65b0\u589e\u8bc1\u4e66\u6a21\u677f")
    @PostMapping(value={"/add"})
    @ResponseBody
    public ResponseData<String> add(@RequestBody Certificate certificate) {
        this.logger.debug("{}-\u65b0\u589e\u8bc1\u4e66\u6a21\u677f", (Object)"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]");
        this.certificateProviderService.addCertificate(certificate);
        return ResponseData.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"cert:edit"})
    @ApiOperation(value="\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f")
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResponseData<String> update(@RequestBody Certificate certificate) {
        this.logger.debug("{}-\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\uff1aid-{}", (Object)"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]", (Object)certificate.getId());
        this.certificateProviderService.updateCertificate(certificate);
        return ResponseData.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"cert:edit"})
    @ApiOperation(value="\u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/updateStatus"})
    @ResponseBody
    public ResponseData<String> updateStatus(@RequestBody CertificateParam param) {
        this.logger.debug("{}-\u542f\u7528/\u7981\u7528\uff1aid-{}\uff0cstatus-{}", new Object[]{"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]", param.getId(), param.getStatus()});
        boolean result = this.certificateProviderService.updateStatus(param.getId(), param.getStatus());
        if (!result) {
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"cert:edit"})
    @ApiOperation(value="\u6279\u91cf\u542f\u7528/\u7981\u7528")
    @PostMapping(value={"/updateStatusBatch"})
    @ResponseBody
    public ResponseData<String> updateStatusBatch(@RequestBody CertificateParam param) {
        this.logger.debug("{}-\u542f\u7528/\u7981\u7528\uff1aid-{}\uff0cstatus-{}", new Object[]{"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]", param.getIds(), param.getStatus()});
        boolean result = this.certificateProviderService.updateStatusBatch(param.getIds(), param.getStatus());
        if (!result) {
            return ResponseData.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseData.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"cert:edit"})
    @ApiOperation(value="\u5220\u9664\u3001\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664\u7528\u82f1\u6587 , \u5206\u9694id")
    @PostMapping(value={"/del"})
    @ResponseBody
    public ResponseData<String> delete(@RequestBody IdsParam ids) {
        this.logger.debug("{}-\u5220\u9664\u3001\u6279\u91cf\u5220\u9664\uff1aids-{}", (Object)"[\u8bc1\u4e66\u6a21\u677f\u7ba1\u7406]", (Object)ids.getIdList());
        this.certificateProviderService.deleteBatch(ids);
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

