/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller.cache;

import cn.hutool.core.util.ArrayUtil;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f13\u5b58\u7ba1\u7406\uff08\u5f00\u53d1\u4eba\u5458\u7528\uff09"})
@RestController
@RequestMapping(value={"/cache"})
public class CacheController
extends ControllerSupport {
    @DubboReference
    private ITuCourseProviderService courseProviderService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u6839\u636ekey\u53bb\u9664\u7f13\u5b58")
    @GetMapping(value={"cleanByKey"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u7f13\u5b58key(\u5220\u9664hash\u7ed3\u6784\u4e2d\u67d0\u4e2a\u503c\u65f6\u7528\u201ckey1,key2\u201d\u8fd9\u79cd\u7ed3\u6784)"), @ApiImplicitParam(name="type", value="\u64cd\u4f5c\u7c7b\u578b\uff081 \u5220\u9664key\u6240\u6709\u503c 2 \u5220\u9664hash\u4e2d\u67d0\u4e2a\u503c\uff09")})
    public ResponseData cleanByKey(String key, Integer type) {
        if (StringUtils.isEmpty((CharSequence)key) || type == null) {
            return ResponseData.fail((String)"\u53c2\u6570\u6570\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (type == 1) {
            this.redisUtil.delete(key);
        } else if (type == 2) {
            Object[] split = key.split(",");
            if (ArrayUtil.isEmpty((Object[])split) || split.length != 2) {
                return ResponseData.fail((String)"key \u9519\u8bef");
            }
            this.redisUtil.delHashCache(split[0], split[1]);
        } else {
            throw new ServiceException("\u672a\u6267\u884c");
        }
        return ResponseData.success((String)"");
    }

    @ApiOperation(value="\u6e05\u9664\u7f13\u5b58")
    @GetMapping(value={"clean"})
    public ResponseData clean() {
        this.redisUtil.delete(RedisKey.getTuCourse(null));
        this.redisUtil.delete(RedisKey.getTuCourseId(null, null));
        this.redisUtil.delete(RedisKey.getTrainCourse(null));
        this.redisUtil.delete(RedisKey.getCatalogue(null));
        this.redisUtil.delete(RedisKey.getCourseItemVo(null));
        this.redisUtil.deleteByPrex(RedisKey.getTrainInfoVo(null) + "*");
        this.redisUtil.deleteByPrex(RedisKey.getTrainWorkType(null) + "*");
        return ResponseData.success((String)"");
    }

    @ApiOperation(value="\u6e05\u9664\u5df2\u5b8c\u6210\u5b66\u4e60\u7684tucoure\u7f13\u5b58")
    @GetMapping(value={"cleanStudiedRecord"})
    public ResponseData cleanStudiedRecord() {
        this.courseProviderService.cleanStuiedRecord();
        return ResponseData.success((String)"");
    }
}

