/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.controller;

import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.annotation.RequestLimit;
import cn.smarthse.radiationTraining.core.framework.interceptor.Log;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogModuleTypeEnum;
import cn.smarthse.radiationTraining.core.framework.interceptor.LogTypeEnum;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.core.framework.utils.AesUtil;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.admin.controller.ControllerSupport;
import cn.smarthse.radiationTraining.modules.sys.provider.admin.IAdminProviderService;
import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.radiationTraining.exception.ServiceException;
import javax.validation.constraints.NotEmpty;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u540e\u53f0-\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference
    private IAdminProviderService userProviderService;

    @ApiOperation(value="\u5bc6\u7801\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", value="\u624b\u673a\u53f7or\u8d26\u53f7or\u90ae\u7bb1", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u767b\u5165")
    @RequestLimit(second=60, maxCount=5, msg="\u8bf71\u5206\u949f\u540e\u91cd\u8bd5")
    @PostMapping(value={"/password"})
    public ResponseData<LoginData> loginByPassword(String username, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotEmpty(message="\u9a8c\u8bc1\u7801key") @NotEmpty(message="\u9a8c\u8bc1\u7801key") String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        if (!this.loginService.checkVcode(key, vode, true)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return ResponseData.success((Object)this.loginService.loginByPassword(username, password));
    }

    @ApiOperation(value="\u76d1\u7ba1\u5355\u70b9\u767b\u5f55", notes="sign\u6709\u6548\u65f6\u95f410min")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sign", value="\u7b7e\u540d", required=true, paramType="query", dataTypeClass=String.class)})
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module7)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.anon, title="\u76d1\u7ba1\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/cas"})
    public ResponseData<LoginData> loginByCas(String sign) {
        String decrypt = AesUtil.decrypt((String)sign);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class);
        String name = (String)jsonObject.getObject("name", String.class);
        Long areaId = (Long)jsonObject.getObject("areaId", Long.class);
        String token = (String)jsonObject.getObject("token", String.class);
        Long time = (Long)jsonObject.getObject("time", Long.class);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class);
        CasToken casToken = new CasToken(username, name, areaId, token);
        FieldCheckUtils.checkEmptyFields((Object)casToken, (String[])new String[]{"username", "name", "areaId", "token"});
        long expreTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        LoginData result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="token\u5237\u65b0")
    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u9a8c\u8bc1\u7801\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="phone", value="\u624b\u673a\u53f7", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="code", value="\u9a8c\u8bc1\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPasswordByPhone"})
    public ResponseData<String> modifyPasswordByPhone(String phone, @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password) {
        this.loginService.modifyPassword(phone, code, password);
        return ResponseData.success();
    }

    @ApiOperation(value="\u8f93\u5165\u65e7\u5bc6\u7801\u4fee\u6539\u5bc6\u7801\uff08\u9700\u8981\u767b\u5f55\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPassword, HttpServletRequest request) {
        Long userId = JwtUtil.getUserId((String)request.getHeader(Constant.TOKEN_HEADER_NAME));
        if (userId == null) {
            return ResponseData.fail((String)"\u672a\u767b\u5f55\uff01");
        }
        this.userProviderService.modifyPasswordByOldPwd(userId, oldPassword, newPassword);
        return ResponseData.success();
    }

    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, paramType="query", dataTypeClass=String.class)
    @RequestLimit(second=60, maxCount=2)
    @PostMapping(value={"/sendEmailCode"})
    public ResponseData<Boolean> sendEmailCode(@ApiParam(value="\u90ae\u7bb1") @RequestParam String email) {
        return ResponseData.success((Object)this.loginService.sendEmailCode(email));
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u7801", hidden=true)
    @ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7", required=true, paramType="query", dataTypeClass=String.class)
    @RequestLimit(second=60, maxCount=2)
    @PostMapping(value={"/sendMobileCode"})
    public ResponseData<Boolean> sendMobileCode(@ApiParam(value="\u624b\u673a\u53f7") @RequestParam String mobile) {
        return ResponseData.success((Object)this.loginService.sendLoginCode(mobile));
    }

    @ApiOperation(value="\u53d1\u9001\u9a8c\u8bc1\u7801")
    @ApiImplicitParam(name="key", value="key\u524d\u7aef\u81ea\u884c\u751f\u6210", required=true, paramType="query", dataTypeClass=String.class)
    @PostMapping(value={"/sendVcode"})
    public ResponseData<String> sendVcode(@ApiParam(value="key") String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVcode(key));
    }

    @ApiOperation(value="\u6821\u9a8c\u90ae\u7bb1\u9a8c\u8bc1\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="code", value="\u9a8c\u8bc1\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/checkEmailCode"})
    public ResponseData<Boolean> checkEmailCode(String email, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String code) {
        return ResponseData.success((Object)this.loginService.checkEmailCode(email, code));
    }

    @ApiOperation(value="\u6821\u9a8c\u9a8c\u8bc1\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u9a8c\u8bc1\u7801key", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="vode", value="\u9a8c\u8bc1\u7801", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/checkVcode"})
    public ResponseData<Boolean> checkVcode(String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        return ResponseData.success((Object)this.loginService.checkVcode(key, vode, false));
    }

    public LoginController(LoginService loginService) {
        this.loginService = loginService;
    }
}

