/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.PermissionsService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.sys.entity.admin.Admin;
import cn.smarthse.radiationTraining.modules.sys.provider.admin.IAdminProviderService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Autowired
    @Lazy
    private LoginService loginService;
    @DubboReference
    private IAdminProviderService userService;
    private final PermissionsService permissionsService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public void doGetAuthorizationInfo(ShiroPrincipal principal) {
        this.permissionsService.addRoleAndPerms(principal);
    }

    public ShiroPrincipal getLoginUser(Long userId) {
        if (userId == null) {
            return null;
        }
        String loginUserKey = RedisKey.getAdminLoginUserKey((Long)userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            Admin user = this.userService.selectUserById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            principal.setUser(this.loginService.toggleSysUser(user));
            this.permissionsService.addRoleAndPerms(principal);
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public Admin selectUserByPhone(String phone) {
        return this.userService.selectUserByPhone(phone);
    }

    public void register(String phone) {
        this.userService.register(phone, new String[0]);
    }

    public Admin registerByUsername(String username, String name, Long areaId, String token) {
        return this.userService.registerByUsername(username, name, areaId, token);
    }

    public boolean updateById(Admin admin) {
        return this.userService.updateById(admin);
    }

    public Admin getByToken(String username) {
        return this.userService.getByToken(username);
    }

    public Admin getByUsername(String username) {
        return this.userService.selectUserByUsername(username);
    }

    public Admin getByThirdToken(String token) {
        return this.userService.getByThirdToken(token);
    }

    public TokenService(PermissionsService permissionsService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.permissionsService = permissionsService;
        this.redisTemplate = redisTemplate;
    }
}

