/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.SpringContextHolder;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        Subject subject = ShiroUtil.getSubject();
        return (ShiroPrincipal)subject.getPrincipal();
    }

    public static UserInfo getUserInfo() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static Long getLoginUserId() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getId() : null;
    }

    public static Long getLoginUserId2() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? Long.valueOf(user.getToken()) : null;
    }

    public static String getLoginUsername() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginUserNickname() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getName() : null;
    }

    public static Long getLoginAreaId() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getAreaId() : null;
    }

    public static Byte getLoginAreaLevel() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getLevel() : null;
    }

    public static Set<Integer> getLoginUserSystemWideList() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getSystemWideList() : CollUtil.newHashSet((Object[])new Integer[0]);
    }

    public static Set<String> getPermissionSet() {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet();
    }

    public static Set<String> getRoleSet() {
        return ShiroUtil.getShiroPrincipal().getRoleSet();
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getPermissionSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getRoleSet().contains(roleCode);
    }

    public static boolean isSuperAdmin() {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains("superadmin");
    }

    public static Boolean getLoginUserIsTest() {
        UserInfo user = ShiroUtil.getUserInfo();
        return user != null ? user.getIsTest() == 1 : Boolean.FALSE;
    }

    public static boolean isSpecifiedUser() {
        String userName = ShiroUtil.getLoginUsername().toUpperCase();
        String specifiedUserName = ((SysProperties)SpringContextHolder.getBean(SysProperties.class)).getSpecifiedUser();
        List<String> specifiedNameList = Arrays.asList(specifiedUserName.split(","));
        if (specifiedNameList.contains(userName)) {
            return true;
        }
        return ShiroUtil.getLoginUserIsTest();
    }

    public static String getTrainingVersion() {
        return ((SysProperties)SpringContextHolder.getBean(SysProperties.class)).getTrainingVersion();
    }
}

