/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.sys.entity.admin.AdminSecRole;
import cn.smarthse.radiationTraining.modules.sys.service.admin.IAdminSecPermService;
import cn.smarthse.radiationTraining.modules.sys.service.admin.IAdminSecRoleService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {
    @DubboReference
    private IAdminSecPermService permService;
    @DubboReference
    private IAdminSecRoleService roleService;

    public List<AdminSecRole> selectRoleList(Long userId) {
        return this.roleService.selectRoleList(userId);
    }

    public boolean addRole(Long userId, Long ... roleIds) {
        return this.roleService.addRole(userId, roleIds);
    }

    public Set<String> selectPermSetByRoleIds(Set<Long> roleIds) {
        return this.permService.selectPermSetByRoleIds(roleIds);
    }

    public void addRoleAndPerms(ShiroPrincipal loginUser) {
        List<AdminSecRole> sysRoles = this.selectRoleList(loginUser.getUserId());
        if (CollUtil.isEmpty(sysRoles)) {
            loginUser.setRoleSet(Collections.emptySet());
            loginUser.setPermissionsSet(Collections.emptySet());
            return;
        }
        loginUser.setRoleSet(sysRoles.stream().map(AdminSecRole::getCode).collect(Collectors.toSet()));
        Set roleIds = sysRoles.stream().map(AdminSecRole::getId).collect(Collectors.toSet());
        List rolePermList = this.permService.getAdminSecRolePermList(roleIds);
        if (rolePermList != null) {
            HashSet<String> authorities = new HashSet<String>();
            rolePermList.forEach(record -> {
                if (record.getHasView().booleanValue()) {
                    authorities.add(record.getCode() + ":view");
                }
                if (record.getHasEdit().booleanValue()) {
                    authorities.add(record.getCode() + ":edit");
                }
            });
            loginUser.setPermissionsSet(authorities);
        }
    }
}

