/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.utils.CommonsUtils;
import cn.smarthse.radiationTraining.core.framework.utils.JwtUtil;
import cn.smarthse.radiationTraining.core.framework.utils.ServletUtils;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.LoginData;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.entity.admin.Admin;
import cn.smarthse.radiationTraining.modules.sys.provider.admin.IAdminProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IEmailProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISmsProviderService;
import com.wf.captcha.SpecCaptcha;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    @DubboReference
    private IAdminProviderService userProviderService;
    @DubboReference
    private ISmsProviderService smsProviderService;
    @DubboReference
    private IEmailProviderService emailProviderService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final TokenService tokenService;

    public boolean sendLoginCode(String phone) {
        return true;
    }

    public LoginData loginByPassword(String phone, String password) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(phone, password);
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
    }

    public LoginData loginByCas(CasToken token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u672a\u77e5\u9519\u8bef\uff01");
        }
    }

    public void modifyPassword(String phone, String code, String password) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getModifyPasswordCodeKey((String)phone));
        if (Objects.isNull(modifyCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        if (!Objects.equals(code, modifyCode.toString())) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.userProviderService.modifyPasswordByPhone(phone, code, password);
    }

    private LoginData returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String name = principal.getUser().getName();
        String ip = ServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = principal.getUser().getPassword();
        this.tokenService.doGetAuthorizationInfo(principal);
        String token = JwtUtil.createToken((String)username, (Long)userId, (String)name, (String)ip, (String)secret, (Long)Constant.TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken((String)username, (Long)userId, (String)secret, (Long)Constant.TOKEN_REFRESH_TIME);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getAdminLoginUserKey((Long)userId), (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getAdminTokenSecret((Long)userId), (Object)secret, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
        principal.getUser().setPassword(null);
        return new LoginData(principal, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        Long userId = JwtUtil.getUserId((String)refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u65e0\u6548\uff01");
        }
        Admin user = this.userProviderService.selectUserById(userId);
        if (user == null) {
            throw new ServiceException(Integer.valueOf(-1), "\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.getTokenSecret(user);
        if (!JwtUtil.verify((String)refreshToken, (String)secret)) {
            throw new ServiceException(Integer.valueOf(-1), "token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)user.getName(), (String)ip, (String)secret, (Long)Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken((String)user.getUsername(), (Long)user.getId(), (String)secret, (Long)Constant.TOKEN_REFRESH_TIME);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)user.getId()), (Object)secret, (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
        return new LoginData(newToken, newRefreshToken);
    }

    private String getTokenSecret(Admin user) {
        String secret = (String)this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getTokenSecret((Long)user.getId()));
        if (secret == null) {
            this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getTokenSecret((Long)user.getId()), (Object)user.getPassword(), (long)Constant.TOKEN_SECRET_EXPIRE_TIME.intValue(), TimeUnit.DAYS);
            return user.getPassword();
        }
        return secret;
    }

    public boolean sendEmailCode(String email) {
        String code = RandomUtil.randomStringUpper((int)6);
        String text = String.format("\u60a8\u7684\u9a8c\u8bc1\u7801\uff1a%s\uff0c5\u5206\u949f\u5185\u6709\u6548\uff01", code);
        this.emailProviderService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword((String)code, (String)email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey((String)email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public String sendVcode(String key) {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 4);
        String code = specCaptcha.text().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey((String)key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.toBase64();
    }

    public boolean checkEmailCode(String email, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey((String)email));
        if (Objects.isNull(modifyCode)) {
            log.info("checkEmailCode: email:{}", (Object)email);
            throw new ServiceException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword((String)String.valueOf(code), (String)email);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkVcode(String key, String vcode, boolean isDelete) {
        Object vodeCache = null;
        vodeCache = isDelete ? this.stringRedisTemplate.opsForValue().getAndDelete((Object)RedisKey.getVCodeKey((String)key)) : this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey((String)key));
        if (Objects.isNull(vodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode.equalsIgnoreCase(vodeCache.toString());
    }

    public UserInfo toggleSysUser(Admin admin) {
        String token = admin.getToken();
        OrganizationUser user = this.organizationUserService.getUserInfoById(Long.valueOf(token));
        if (user == null) {
            throw new UnknownAccountException();
        }
        Organization org = this.organizationService.getOrgById(user.getOid());
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(org.getAreaId());
        UserInfo result = new UserInfo();
        result.setId(admin.getId());
        result.setUsername(admin.getUsername());
        result.setPhone(user.getTel());
        result.setAvatar(admin.getAvatar());
        result.setName(user.getUsername());
        result.setSex(admin.getAvatar());
        result.setBirth(admin.getBirth());
        result.setPassword(admin.getPassword());
        result.setAreaId(org.getAreaId());
        result.setLevel(area.getLevel());
        result.setToken(token);
        result.setIsTest(user.getIsTest());
        result.setSystemWideList(user.getSystemWideList());
        result.setUserFrom(user.getUserFrom() != null ? Integer.valueOf(user.getUserFrom().byteValue()) : null);
        result.setOperationRole(null);
        return result;
    }

    public LoginService(StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, TokenService tokenService) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.tokenService = tokenService;
    }
}

