/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.admin.bootstrap.security.realms;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.LoginService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.service.TokenService;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.CasToken;
import cn.smarthse.radiationTraining.modules.admin.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.radiationTraining.modules.sys.entity.admin.Admin;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class CasRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CasRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;
    @Autowired
    @Lazy
    private LoginService loginService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof CasToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        CasToken token = (CasToken)authenticationToken;
        log.info("{} - cas auth start...", (Object)token.getUsername());
        Admin user = this.tokenService.getByThirdToken(token.getToken());
        if (user == null) {
            user = this.tokenService.registerByUsername(token.getUsername(), token.getName(), token.getAreaId(), token.getToken());
        } else {
            user.setUsername(token.getUsername());
            user.setName(token.getName());
            user.setAreaId(token.getAreaId());
            this.tokenService.updateById(user);
        }
        if (user.getIsForbidden() == Constant.YES) {
            throw new DisabledAccountException();
        }
        String realmName = super.getName();
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(this.loginService.toggleSysUser(user)), (Object)"", realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

