/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor.sql;

import cn.smarthse.mybatis.changemonitor.enumerate.DBActionTypeEnum;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;

public class SqlParserInfo {
    private DBActionTypeEnum actionType;
    private String tableName;
    private String schemaName;
    private Table table;
    private Expression whereExpression;

    public SqlParserInfo(String sql, DBActionTypeEnum actionType) throws JSQLParserException {
        this.actionType = actionType;
        if (sql == null || sql.length() <= 0) {
            return;
        }
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (actionType == DBActionTypeEnum.UPDATE) {
            Update updateStatement = (Update)statement;
            Table updateTables = updateStatement.getTable();
            if (updateTables == null) {
                return;
            }
            this.table = updateTables;
            this.whereExpression = updateStatement.getWhere();
        } else if (actionType == DBActionTypeEnum.INSERT) {
            Insert deleteStatement = (Insert)statement;
            Table deleteTable = deleteStatement.getTable();
            if (deleteTable == null) {
                return;
            }
            this.table = deleteTable;
            this.whereExpression = null;
        } else if (actionType == DBActionTypeEnum.DELETE) {
            Delete deleteStatement = (Delete)statement;
            Table deleteTables = deleteStatement.getTable();
            if (deleteTables == null) {
                return;
            }
            this.table = deleteTables;
            this.whereExpression = deleteStatement.getWhere();
        }
        this.tableName = this.table.getName();
        this.schemaName = this.table.getSchemaName();
    }

    public DBActionTypeEnum getActionType() {
        return this.actionType;
    }

    public void setActionType(DBActionTypeEnum actionType) {
        this.actionType = actionType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }
}

