/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor.sql;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.SelectUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class JsqlParserHelper {
    public static List<String> getWhereColumn(Expression whereExpression) {
        final ArrayList<String> result = new ArrayList<String>();
        whereExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(Column expr) {
                if (!result.contains(expr.getColumnName())) {
                    result.add(expr.getColumnName().toLowerCase());
                }
            }
        });
        return result;
    }

    public static Select getSelect(Table table, List<Column> column, Expression whereExpression) {
        Column[] selectColumns = column.toArray(new Column[column.size()]);
        Select select = SelectUtils.buildSelectFromTableAndExpressions((Table)table, (Expression[])selectColumns);
        PlainSelect selectPlain = (PlainSelect)select.getSelectBody();
        selectPlain.setWhere(whereExpression);
        return select;
    }

    public static List<ParameterMapping> getSelectParamMap(Configuration configuration, BoundSql boundSql) {
        ArrayList<ParameterMapping> selectParamMap = new ArrayList<ParameterMapping>();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ").toLowerCase();
        int paramNum = sql.split("\\?").length - 1;
        sql = sql.substring(sql.indexOf(" where "));
        int whereParamNum = sql.split("\\?").length - 1;
        int num = paramNum - whereParamNum;
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings.size() > 0) {
            for (ParameterMapping parameterMapping : parameterMappings) {
                if (num > 0) {
                    --num;
                    continue;
                }
                selectParamMap.add(parameterMapping);
            }
        }
        return selectParamMap;
    }

    public static String getSelectSql(Configuration configuration, BoundSql boundSql) {
        String sql = JsqlParserHelper.showSql(configuration, boundSql).toLowerCase();
        if (sql == null) {
            return null;
        }
        if (sql.startsWith("delete ")) {
            sql = "SELECT * " + sql.substring(sql.indexOf(" from "));
        } else if (sql.startsWith("update ")) {
            String tempSql = sql.substring(sql.indexOf(" where "));
            sql = sql.substring(0, sql.indexOf(" set ")) + tempSql;
            sql = sql.replace("update", "select * from");
        }
        return sql;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", JsqlParserHelper.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", JsqlParserHelper.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", JsqlParserHelper.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }
}

