/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor.parse;

import cn.smarthse.mybatis.changemonitor.domain.ChangeData;
import cn.smarthse.mybatis.changemonitor.domain.ChangeDataUtil;
import cn.smarthse.mybatis.changemonitor.enumerate.DBActionTypeEnum;
import cn.smarthse.mybatis.changemonitor.filter.FilterContext;
import cn.smarthse.mybatis.changemonitor.mybatis.MybatisParameterUtils;
import cn.smarthse.mybatis.changemonitor.parse.MybatisInvocation;
import cn.smarthse.mybatis.changemonitor.parse.ParseData;
import cn.smarthse.mybatis.changemonitor.sql.SqlParserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

public class ParseInsertData
implements ParseData {
    @Override
    public List<ChangeData> parse(String commandName, MybatisInvocation mybatisInvocation) throws Throwable {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        Object updateParameterObject = mybatisInvocation.getParameter();
        BoundSql boundSql = mappedStatement.getBoundSql(mybatisInvocation.getParameter());
        String sql = boundSql.getSql();
        SqlParserInfo sqlParserInfo = new SqlParserInfo(sql, DBActionTypeEnum.INSERT);
        Boolean validateBoolean = FilterContext.validate(sqlParserInfo.getTableName(), mybatisInvocation);
        if (!validateBoolean.booleanValue()) {
            return null;
        }
        List<Map<String, Object>> updateDataMap = MybatisParameterUtils.getParameterList(mappedStatement, boundSql, updateParameterObject);
        ArrayList<ChangeData> changeDatas = new ArrayList<ChangeData>();
        for (Map<String, Object> map : updateDataMap) {
            ChangeData changeDate = ChangeDataUtil.buildChangeDataForInsert(map);
            changeDate.setTableName(sqlParserInfo.getTableName());
            changeDate.setSchemaName(sqlParserInfo.getSchemaName());
            changeDate.setEventType(DBActionTypeEnum.INSERT.getKey());
            changeDatas.add(changeDate);
        }
        return changeDatas;
    }
}

