/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor.parse;

import cn.smarthse.mybatis.changemonitor.domain.ChangeData;
import cn.smarthse.mybatis.changemonitor.domain.ChangeDataUtil;
import cn.smarthse.mybatis.changemonitor.enumerate.DBActionTypeEnum;
import cn.smarthse.mybatis.changemonitor.filter.FilterContext;
import cn.smarthse.mybatis.changemonitor.mybatis.MSUtils;
import cn.smarthse.mybatis.changemonitor.parse.MybatisInvocation;
import cn.smarthse.mybatis.changemonitor.parse.ParseData;
import cn.smarthse.mybatis.changemonitor.sql.JsqlParserHelper;
import cn.smarthse.mybatis.changemonitor.sql.SqlParserInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jsqlparser.schema.Column;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

public class ParseDeleteData
implements ParseData {
    @Override
    public List<ChangeData> parse(String commandName, MybatisInvocation mybatisInvocation) throws Throwable {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        BoundSql boundSql = mappedStatement.getBoundSql(mybatisInvocation.getParameter());
        String sql = boundSql.getSql();
        SqlParserInfo sqlParserInfo = new SqlParserInfo(sql, DBActionTypeEnum.DELETE);
        Boolean validateBoolean = FilterContext.validate(sqlParserInfo.getTableName(), mybatisInvocation);
        if (!validateBoolean.booleanValue()) {
            return null;
        }
        ArrayList<HashMap<String, Object>> beforeRsults = this.queryWillUpdateDatas(mybatisInvocation, boundSql, sqlParserInfo);
        List<ChangeData> results = this.buildChangeDatas(beforeRsults, sqlParserInfo);
        return results;
    }

    private List<ChangeData> buildChangeDatas(ArrayList<HashMap<String, Object>> beforeResults, SqlParserInfo sqlParserInfo) {
        ArrayList<ChangeData> changeDatas = new ArrayList<ChangeData>();
        if (beforeResults != null && !beforeResults.isEmpty()) {
            for (HashMap<String, Object> queryDataMap : beforeResults) {
                ChangeData changeData = ChangeDataUtil.buildChangeDataForDelete(queryDataMap);
                changeData.setTableName(sqlParserInfo.getTableName());
                changeData.setSchemaName(sqlParserInfo.getSchemaName());
                changeData.setEventType(DBActionTypeEnum.DELETE.getKey());
                changeDatas.add(changeData);
            }
        }
        return changeDatas;
    }

    private ArrayList<HashMap<String, Object>> queryWillUpdateDatas(MybatisInvocation mybatisInvocation, BoundSql boundSql, SqlParserInfo sqlParserInfo) throws SQLException {
        MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
        MappedStatement selectMappedStatement = MSUtils.newHashMapMappedStatement(mappedStatement);
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        Column column = new Column();
        column.setColumnName("*");
        updateColumns.add(column);
        Configuration configuration = mappedStatement.getConfiguration();
        String selectSqlString = JsqlParserHelper.getSelectSql(configuration, boundSql);
        selectSqlString = mybatisInvocation.getDbDialect().getLimitSql(selectSqlString, mybatisInvocation.getMaxRowMonitor());
        ArrayList selectParamMap = new ArrayList();
        BoundSql queryBoundSql = new BoundSql(mybatisInvocation.getMappedStatement().getConfiguration(), selectSqlString, selectParamMap, mybatisInvocation.getParameter());
        List queryResultList = mybatisInvocation.getExecutor().query(selectMappedStatement, mybatisInvocation.getParameter(), RowBounds.DEFAULT, null, null, queryBoundSql);
        ArrayList queryResults = (ArrayList)queryResultList;
        return queryResults;
    }
}

