/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;

public class MybatisParameterUtils {
    public static Map<String, Object> getParameter(MappedStatement mappedStatement, BoundSql boundSql, Object updateParameterObject) {
        Configuration configuration = mappedStatement.getConfiguration();
        List parameterMappings = boundSql.getParameterMappings();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (mappedStatement.getStatementType() == StatementType.PREPARED && parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (updateParameterObject == null) {
                    value = null;
                } else if (mappedStatement.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(updateParameterObject.getClass())) {
                    value = updateParameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(updateParameterObject);
                    value = metaObject.getValue(propertyName);
                }
                paramMap.put(MybatisParameterUtils.HumpToUnderline(propertyName).toLowerCase(), value);
            }
        }
        return paramMap;
    }

    public static List<Map<String, Object>> getParameterList(MappedStatement mappedStatement, BoundSql boundSql, Object updateParameterObject) {
        Configuration configuration = mappedStatement.getConfiguration();
        List parameterMappings = boundSql.getParameterMappings();
        ArrayList<Map<String, Object>> paramMapList = new ArrayList<Map<String, Object>>();
        if (mappedStatement.getStatementType() == StatementType.PREPARED && parameterMappings != null) {
            ParameterMapping parameterMapping;
            int i;
            int num = 0;
            HashMap<String, Integer> keyList = new HashMap<String, Integer>();
            for (i = 0; i < parameterMappings.size(); ++i) {
                String propertyName;
                parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT || (propertyName = parameterMapping.getProperty()).indexOf(".") <= 0 || keyList.get(propertyName = propertyName.substring(0, propertyName.indexOf("."))) != null) continue;
                keyList.put(propertyName, num++);
                paramMapList.add(new HashMap());
            }
            if (num == 0) {
                paramMapList.add(new HashMap());
            }
            for (i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                String propertyName1 = null;
                if (num > 0) {
                    propertyName1 = propertyName.substring(0, propertyName.indexOf("."));
                }
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (updateParameterObject == null) {
                    value = null;
                } else if (mappedStatement.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(updateParameterObject.getClass())) {
                    value = updateParameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(updateParameterObject);
                    value = metaObject.getValue(propertyName);
                }
                if (num > 0) {
                    ((Map)paramMapList.get((Integer)keyList.get(propertyName1))).put(MybatisParameterUtils.HumpToUnderline(propertyName.replace(propertyName1 + ".", "")).toLowerCase(), value);
                    continue;
                }
                ((Map)paramMapList.get(num)).put(MybatisParameterUtils.HumpToUnderline(propertyName).toLowerCase(), value);
            }
        }
        return paramMapList;
    }

    public static String HumpToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toUpperCase();
    }
}

