/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.mybatis.changemonitor;

import cn.smarthse.mybatis.changemonitor.AbstractMonitor;
import cn.smarthse.mybatis.changemonitor.dialect.AbstractDialect;
import cn.smarthse.mybatis.changemonitor.dialect.Db2Dialect;
import cn.smarthse.mybatis.changemonitor.dialect.MySqlDialect;
import cn.smarthse.mybatis.changemonitor.dialect.OracleDialect;
import cn.smarthse.mybatis.changemonitor.domain.ChangeData;
import cn.smarthse.mybatis.changemonitor.enumerate.DBType;
import cn.smarthse.mybatis.changemonitor.parse.MybatisInvocation;
import cn.smarthse.mybatis.changemonitor.parse.ParseContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ChangeMonitorInterceptor
implements Interceptor {
    private AbstractMonitor monitor;
    private AbstractDialect dbDialect;
    private int maxRowMonitor = 1000;
    private static final String PROPERTY_DBNAME = "dbname";
    private static final String PROPERTY_MAX_ROW_MONITOR = "maxRowMonitor";
    private static final String PROPERTY_WHITE_LIST = "whiteList";
    CopyOnWriteArrayList<String> whiteCopyList = new CopyOnWriteArrayList();
    private static Map<String, AbstractDialect> dbDialectMap = new HashMap<String, AbstractDialect>();

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.monitor == null) {
            return null;
        }
        Object target = invocation.getTarget();
        Object result = null;
        if (target instanceof Executor) {
            MybatisInvocation mybatisInvocation;
            Object[] args = invocation.getArgs();
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            ParseContext parseContent = new ParseContext();
            String commandName = ms.getSqlCommandType().name();
            List<ChangeData> changeTable = parseContent.parse(commandName, mybatisInvocation = new MybatisInvocation(args, ms, parameter, (Executor)target, this.dbDialect, this.maxRowMonitor, this.whiteCopyList));
            if (changeTable != null) {
                this.monitor.listen(changeTable);
            }
            result = invocation.proceed();
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String whiteList;
        if (!properties.containsKey(PROPERTY_DBNAME)) {
            throw new RuntimeException("must set property dbname.");
        }
        String dbname = properties.getProperty(PROPERTY_DBNAME);
        String maxRowMonitorString = properties.getProperty(PROPERTY_MAX_ROW_MONITOR);
        String monitorFullPath = properties.getProperty("monitor");
        if (!this.isEmpty(monitorFullPath).booleanValue()) {
            try {
                Object object = Class.forName(monitorFullPath).newInstance();
                this.monitor = (AbstractMonitor)object;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.isEmpty(dbname).booleanValue()) {
            throw new RuntimeException("must set property dbname.");
        }
        if (!this.isEmpty(maxRowMonitorString).booleanValue()) {
            try {
                this.maxRowMonitor = Integer.getInteger(maxRowMonitorString);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Illegal maxRowMonitor : [%s] ", maxRowMonitorString));
            }
        }
        if (!dbDialectMap.containsKey(dbname)) {
            throw new IllegalArgumentException(String.format("Illegal dbName[%s]", dbname));
        }
        this.dbDialect = dbDialectMap.get(dbname);
        if (properties.containsKey(PROPERTY_WHITE_LIST) && !this.isEmpty(whiteList = properties.getProperty(PROPERTY_WHITE_LIST)).booleanValue()) {
            String[] whiteListArray = whiteList.split(",");
            this.whiteCopyList = new CopyOnWriteArrayList<String>(whiteListArray);
        }
    }

    public AbstractMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(AbstractMonitor monitor) {
        this.monitor = monitor;
    }

    private Boolean isEmpty(String str) {
        if (str == null || str.length() <= 0) {
            return true;
        }
        return false;
    }

    static {
        dbDialectMap.put(DBType.MY_SQL.getValue(), new MySqlDialect());
        dbDialectMap.put(DBType.ORACLE.getValue(), new OracleDialect());
        dbDialectMap.put(DBType.DB2.getValue(), new Db2Dialect());
    }
}

