package cn.smarthse.mybatis.changemonitor.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

import cn.smarthse.mybatis.changemonitor.domain.ChangeData;
import cn.smarthse.mybatis.changemonitor.domain.ChangeDataUtil;
import cn.smarthse.mybatis.changemonitor.enumerate.DBActionTypeEnum;
import cn.smarthse.mybatis.changemonitor.filter.FilterContext;
import cn.smarthse.mybatis.changemonitor.mybatis.MybatisParameterUtils;
import cn.smarthse.mybatis.changemonitor.sql.SqlParserInfo;


public class ParseInsertData implements ParseData {
	@Override
	public List<ChangeData> parse(String commandName, MybatisInvocation mybatisInvocation) throws Throwable {
		MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
		Object updateParameterObject = mybatisInvocation.getParameter();
		BoundSql boundSql = mappedStatement.getBoundSql(mybatisInvocation.getParameter());
		String sql = boundSql.getSql();
		SqlParserInfo sqlParserInfo = new SqlParserInfo(sql, DBActionTypeEnum.INSERT);

		//校验过滤
		Boolean validateBoolean =  FilterContext.validate(sqlParserInfo.getTableName(), mybatisInvocation);
		if(!validateBoolean){
			return null;
		}
				
		// 获取更新字段列表
		List<Map<String, Object>> updateDataMap = MybatisParameterUtils.getParameterList(mappedStatement, boundSql, updateParameterObject);
		
		
		
		List<ChangeData> changeDatas = new ArrayList<>();
		for(Map<String, Object> map:updateDataMap) {
			ChangeData changeDate = ChangeDataUtil.buildChangeDataForInsert(map);
			changeDate.setTableName(sqlParserInfo.getTableName());
			changeDate.setSchemaName(sqlParserInfo.getSchemaName());
			changeDate.setEventType(DBActionTypeEnum.INSERT.getKey());
			
			changeDatas.add(changeDate);
		}

		return changeDatas;
	}
}
