package cn.smarthse.mybatis.changemonitor.parse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

import cn.smarthse.mybatis.changemonitor.domain.ChangeData;
import cn.smarthse.mybatis.changemonitor.domain.ChangeDataUtil;
import cn.smarthse.mybatis.changemonitor.enumerate.DBActionTypeEnum;
import cn.smarthse.mybatis.changemonitor.filter.FilterContext;
import cn.smarthse.mybatis.changemonitor.mybatis.MSUtils;
import cn.smarthse.mybatis.changemonitor.sql.JsqlParserHelper;
import cn.smarthse.mybatis.changemonitor.sql.SqlParserInfo;
import net.sf.jsqlparser.schema.Column;


public class ParseDeleteData implements ParseData {
	@Override
	public List<ChangeData> parse(String commandName, MybatisInvocation mybatisInvocation) throws Throwable {
		MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
		BoundSql boundSql = mappedStatement.getBoundSql(mybatisInvocation.getParameter());
		String sql = boundSql.getSql();
		
		SqlParserInfo sqlParserInfo = new SqlParserInfo(sql, DBActionTypeEnum.DELETE);

		//校验过滤
		Boolean validateBoolean =  FilterContext.validate(sqlParserInfo.getTableName(), mybatisInvocation);
		if(!validateBoolean){
			return null;
		}
				
		// 获取要更新数据
		ArrayList<HashMap<String, Object>> beforeRsults = queryWillUpdateDatas(mybatisInvocation, boundSql, sqlParserInfo);

		List<ChangeData> results = buildChangeDatas(beforeRsults,sqlParserInfo);
		
		return results;
	}
	private List<ChangeData> buildChangeDatas(final ArrayList<HashMap<String, Object>> beforeResults, SqlParserInfo sqlParserInfo){
		List<ChangeData> changeDatas = new ArrayList<>();
		if(beforeResults != null && !beforeResults.isEmpty()){
			for(HashMap<String, Object> queryDataMap : beforeResults){
				ChangeData changeData = ChangeDataUtil.buildChangeDataForDelete(queryDataMap);
				changeData.setTableName(sqlParserInfo.getTableName());
				changeData.setSchemaName(sqlParserInfo.getSchemaName());
				changeData.setEventType(DBActionTypeEnum.DELETE.getKey());
				changeDatas.add(changeData);
			}
		}
		return changeDatas;
	}
	
	private ArrayList<HashMap<String, Object>> queryWillUpdateDatas(MybatisInvocation mybatisInvocation, 
			BoundSql boundSql, SqlParserInfo sqlParserInfo) throws SQLException {
		MappedStatement mappedStatement = mybatisInvocation.getMappedStatement();
		MappedStatement selectMappedStatement = MSUtils.newHashMapMappedStatement(mappedStatement);
		List<Column> updateColumns = new ArrayList<>();
		Column column = new Column();
		column.setColumnName("*");
		updateColumns.add(column);
		Configuration configuration = mappedStatement.getConfiguration();
		String selectSqlString = JsqlParserHelper.getSelectSql(configuration, boundSql);
		
		// 查询数量限制
		selectSqlString = mybatisInvocation.getDbDialect().getLimitSql(selectSqlString, mybatisInvocation.getMaxRowMonitor());

		List<ParameterMapping> selectParamMap = new ArrayList<>();

		BoundSql queryBoundSql = new BoundSql(mybatisInvocation.getMappedStatement().getConfiguration(), selectSqlString, selectParamMap, mybatisInvocation.getParameter());
		Object queryResultList = mybatisInvocation.getExecutor().query(selectMappedStatement, mybatisInvocation.getParameter(), RowBounds.DEFAULT, null, null, queryBoundSql);
		@SuppressWarnings("unchecked")
		ArrayList<HashMap<String, Object>> queryResults = (ArrayList<HashMap<String, Object>>) queryResultList;
		return queryResults;
	}
}
