package cn.smarthse.mybatis.changemonitor.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;


public class MybatisParameterUtils {
	public static Map<String, Object> getParameter(MappedStatement mappedStatement, BoundSql boundSql, Object updateParameterObject){
		Configuration configuration = mappedStatement.getConfiguration();
		List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
		Map<String, Object> paramMap = new HashMap<>();
		if(mappedStatement.getStatementType() == StatementType.PREPARED){
			if (parameterMappings != null) {
			      for (int i = 0; i < parameterMappings.size(); i++) {
			    	  ParameterMapping parameterMapping = parameterMappings.get(i);
			    	  if (parameterMapping.getMode() != ParameterMode.OUT) {
			    		  Object value;
			              String propertyName = parameterMapping.getProperty();
			              
			              if (boundSql.hasAdditionalParameter(propertyName)) { 
			                  value = boundSql.getAdditionalParameter(propertyName);
			                } else if (updateParameterObject == null) {
			                  value = null;
			                } else if (mappedStatement.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(updateParameterObject.getClass())) {
			                  value = updateParameterObject;
			                } else {
			                  MetaObject metaObject = configuration.newMetaObject(updateParameterObject);
			                  value = metaObject.getValue(propertyName);
			                }
			              
			              paramMap.put(HumpToUnderline(propertyName).toLowerCase(), value);
			    	  }
			      }
			}
		}
		return paramMap;
	}
	
	public static List<Map<String, Object>> getParameterList(MappedStatement mappedStatement, BoundSql boundSql, Object updateParameterObject){
		Configuration configuration = mappedStatement.getConfiguration();
		List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
		List<Map<String, Object>> paramMapList = new ArrayList<>();
		if(mappedStatement.getStatementType() == StatementType.PREPARED){
			if (parameterMappings != null) {
				int num = 0;
				Map<String, Integer> keyList = new HashMap<>();
				for (int i = 0; i < parameterMappings.size(); i++) {
					ParameterMapping parameterMapping = parameterMappings.get(i);
					if (parameterMapping.getMode() != ParameterMode.OUT) {
						String propertyName = parameterMapping.getProperty();
						if (propertyName.indexOf(".") > 0) {
							propertyName = propertyName.substring(0, propertyName.indexOf("."));
							if (keyList.get(propertyName) == null) {
								keyList.put(propertyName, num++);
								paramMapList.add(new HashMap<String, Object>());
							}
						}
					}
				}
				if (num == 0) {
					paramMapList.add(new HashMap<String, Object>());
				}

				for (int i = 0; i < parameterMappings.size(); i++) {
					ParameterMapping parameterMapping = parameterMappings.get(i);
					if (parameterMapping.getMode() != ParameterMode.OUT) {
						Object value;
						String propertyName = parameterMapping.getProperty();
						String propertyName1 = null;
						if (num > 0) {
							propertyName1 = propertyName.substring(0, propertyName.indexOf("."));
						}

						if (boundSql.hasAdditionalParameter(propertyName)) {
							value = boundSql.getAdditionalParameter(propertyName);
						} else if (updateParameterObject == null) {
							value = null;
						} else if (mappedStatement.getConfiguration().getTypeHandlerRegistry()
								.hasTypeHandler(updateParameterObject.getClass())) {
							value = updateParameterObject;
						} else {
							MetaObject metaObject = configuration.newMetaObject(updateParameterObject);
							value = metaObject.getValue(propertyName);
						}
						if (num > 0) {
							paramMapList.get(keyList.get(propertyName1))
									.put(HumpToUnderline(propertyName.replace(propertyName1+".", "")).toLowerCase(), value);
						} else {
							paramMapList.get(num).put(HumpToUnderline(propertyName).toLowerCase(), value);
						}
					}
				}
			}
		}
		return paramMapList;
	}
	
	public static String HumpToUnderline(String para){
        StringBuilder sb=new StringBuilder(para);
        int temp=0;//定位
        for(int i=0;i<para.length();i++){
            if(Character.isUpperCase(para.charAt(i))){
                sb.insert(i+temp, "_");
                temp+=1;
            }
        }
        return sb.toString().toUpperCase(); 
	}
}

