package cn.smarthse.mybatis.changemonitor.filter;

import java.util.concurrent.CopyOnWriteArrayList;

import cn.smarthse.mybatis.changemonitor.parse.MybatisInvocation;


public class WhiteListFilter implements Filter{
	@Override
	public Boolean validate(String tableName, MybatisInvocation mybatisInvocation) {
		CopyOnWriteArrayList<String> whiteList = mybatisInvocation.getWhiteCopyList();
		if(whiteList!=null && whiteList.size()>0){
			if(whiteList.contains(tableName)){
				return true;
			}else{
				return false;
			}
		}else{
			return true;
		}
	}
}

