package cn.smarthse.mybatis.changemonitor.domain;

import java.util.*;
import java.util.Map.Entry;


public class ChangeDataUtil {

	public static ChangeData buildChangeDataForInsert(final Map<String, Object> afterDataMap) {
		ChangeData changeData = new ChangeData();
		List<ChangeObject> afterColumnList = new ArrayList<>();
		List<ChangeObject> beforeColumnList = new ArrayList<>();
		changeData.setAfterColumnList(afterColumnList);
		changeData.setBeforeColumnList(beforeColumnList);

		ChangeObject changeObject;
		for (Entry<String, Object> queryDataItem : afterDataMap.entrySet()) {
			String queryDataItemKey = queryDataItem.getKey();
//			String queryDataItemValue = queryDataItem.getValue() != null ? queryDataItem.getValue().toString() : null;

			// set after change object
			changeObject = new ChangeObject();
			changeObject.setName(queryDataItemKey);
			changeObject.setValue(queryDataItem.getValue());
			afterColumnList.add(changeObject);
		}

		return changeData;
	}
	
	
	public static ChangeData buildChangeDataForDelete(final Map<String, Object> beforeDataMap) {
		ChangeData changeData = new ChangeData();
		List<ChangeObject> afterColumnList = new ArrayList<>();
		List<ChangeObject> beforeColumnList = new ArrayList<>();
		changeData.setAfterColumnList(afterColumnList);
		changeData.setBeforeColumnList(beforeColumnList);

		ChangeObject changeObject;
		for (Entry<String, Object> queryDataItem : beforeDataMap.entrySet()) {
			String queryDataItemKey = queryDataItem.getKey();
//			String queryDataItemValue = queryDataItem.getValue() != null ? queryDataItem.getValue().toString() : null;

			// set after change object
			changeObject = new ChangeObject();
			changeObject.setName(queryDataItemKey);
			changeObject.setValue(queryDataItem.getValue());
			beforeColumnList.add(changeObject);
		}
		return changeData;
	}

	public static ChangeData buildChangeDataForUpdate(final Map<String, Object> changeDataMap, HashMap<String, Object> queryDataMap) {
		ChangeData changeData = new ChangeData();
		List<ChangeObject> afterColumnList = new ArrayList<>();
		List<ChangeObject> beforeColumnList = new ArrayList<>();
		changeData.setAfterColumnList(afterColumnList);
		changeData.setBeforeColumnList(beforeColumnList);
		if (queryDataMap == null) {
			return changeData;
		}
		ChangeObject changeObject;
		for (Entry<String, Object> queryDataItem : queryDataMap.entrySet()) {
			String queryDataItemKey = queryDataItem.getKey();
//			String queryDataItemValue = queryDataItem.getValue() != null ? queryDataItem.getValue().toString() : null;

			// set before change object
			changeObject = new ChangeObject();
			changeObject.setName(queryDataItemKey);
			changeObject.setValue(queryDataItem.getValue());
			beforeColumnList.add(changeObject);

			// set after change object
			changeObject = new ChangeObject();
			changeObject.setName(queryDataItemKey);
			if (changeDataMap != null && changeDataMap.containsKey(queryDataItemKey.toLowerCase())) {
//				String resultValueString = changeDataMap.get(queryDataItemKey.toLowerCase()) != null ? changeDataMap.get(queryDataItemKey.toLowerCase()).toString() : null;
				changeObject.setValue(changeDataMap.get(queryDataItemKey.toLowerCase()));
			} else {
				changeObject.setValue(queryDataItem.getValue());
			}
			afterColumnList.add(changeObject);
		}
		
		//重新循环一遍，以便将query没有的字段信息，而change里面有的。没有添加到字段列表里面去。
		if(queryDataMap != null) {
			for (Entry<String, Object> changeDataItem : changeDataMap.entrySet()) {
				String changeDataItemKey = changeDataItem.getKey();
				if(!queryDataMap.containsKey(changeDataItemKey.toLowerCase())) {
					changeObject = new ChangeObject();
					changeObject.setName(changeDataItemKey);
					changeObject.setValue(null);
					beforeColumnList.add(changeObject);
					
					changeObject = new ChangeObject();
					changeObject.setName(changeDataItemKey);
					if (changeDataMap != null && changeDataMap.containsKey(changeDataItemKey.toLowerCase())) {
//						String resultValueString = changeDataMap.get(queryDataItemKey.toLowerCase()) != null ? changeDataMap.get(queryDataItemKey.toLowerCase()).toString() : null;
						changeObject.setValue(changeDataMap.get(changeDataItemKey.toLowerCase()));
					} else {
						changeObject.setValue(null);
					}
					afterColumnList.add(changeObject);
				}
			}
		}

		return changeData;
	}
}
