/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Signature {
    private static final char SEPERATOR = '\u0001';
    private static final char DELIMITER = '\n';
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String MD5 = "MD5";
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String method;
    private String timestamp;
    private String nonce;
    private String path;
    private TreeMap<String, String> parameter = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private String secretKey;

    private Signature() {
    }

    public static Signature newInstance() {
        return new Signature();
    }

    public Signature path(String path) {
        this.path = path;
        return this;
    }

    public Signature method(String method) {
        this.method = method;
        return this;
    }

    public Signature secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String sign() {
        ByteArrayOutputStream output = this.buildByteStream();
        return this.hmacSha256(output.toByteArray());
    }

    public String signMd5() {
        ByteArrayOutputStream output = this.buildByteStream();
        output.write(10);
        try {
            output.write(this.secretKey.getBytes(Consts.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.md5hex(output.toByteArray());
    }

    private ByteArrayOutputStream buildByteStream() {
        byte[] parameterBytes = this.assembleParameter();
        this.timestamp = this.currentNow();
        this.nonce = StringUtils.join((Object[])new String[]{String.valueOf(System.nanoTime()), RandomStringUtils.randomNumeric((int)4)});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            output.write(this.method.getBytes(Consts.UTF_8));
            output.write(10);
            output.write(this.timestamp.getBytes(Consts.UTF_8));
            output.write(10);
            output.write(this.nonce.getBytes(Consts.UTF_8));
            output.write(10);
            output.write(this.path.getBytes(Consts.UTF_8));
            if (ArrayUtils.isNotEmpty((byte[])parameterBytes)) {
                output.write(10);
                output.write(parameterBytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output;
    }

    public void addParameter(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)value) || StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        if (this.parameter.containsKey(name)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.parameter.get(name)).append('\u0001').append(value);
            this.parameter.put(name, sb.toString());
            return;
        }
        this.parameter.put(name, value);
    }

    private byte[] assembleParameter() {
        if (this.parameter.isEmpty()) {
            return EMPTY_BYTES;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.parameter.entrySet()) {
            if (StringUtils.contains((CharSequence)entry.getValue(), (int)1)) {
                String[] arr = StringUtils.split((String)entry.getValue(), (char)'\u0001');
                ArrayList<String> list = new ArrayList<String>();
                for (String element : arr) {
                    list.add(element);
                }
                Collections.sort(list);
                for (String str : list) {
                    sb.append("&").append(String.format("%s=%s", entry.getKey(), str));
                }
                continue;
            }
            sb.append("&").append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        String content = sb.substring(1);
        return content.getBytes(Consts.UTF_8);
    }

    private String currentNow() {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
        return dateTimeFormatter.print((ReadableInstant)new DateTime());
    }

    private String hmacSha256(byte[] message) {
        byte[] secretKeyBytes = this.secretKey.getBytes(Consts.UTF_8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyBytes, HMAC_SHA256);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(secretKeySpec);
            mac.update(message);
            byte[] digestBytes = Base64.encodeBase64((byte[])mac.doFinal());
            return new String(digestBytes, Consts.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    private String md5hex(byte[] message) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MD5);
            messageDigest.update(message);
            byte[] digest = messageDigest.digest();
            int j = digest.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = digest[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getTimestamp() {
        return this.timestamp;
    }
}

