/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.xxpt.gateway.shared.client.asynchttp;

import com.alibaba.xxpt.gateway.shared.client.asynchttp.AsyncExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.asynchttp.InvokeCallback;
import com.alibaba.xxpt.gateway.shared.client.sign.Signature;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.util.Fields;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AsyncPostClient {
    private Request request;
    private AsyncExecutableClient asyncExecutableClient;
    private InvokeCallback invokeCallback;
    private Fields fields = new Fields();
    private Signature signature = Signature.newInstance();

    public AsyncPostClient(AsyncExecutableClient asyncExecutableClient, Request request, InvokeCallback invokeCallback) {
        this.request = request;
        this.asyncExecutableClient = asyncExecutableClient;
        this.invokeCallback = invokeCallback;
    }

    public AsyncPostClient addParameter(String key, String value) {
        this.fields.add(key, value);
        this.signature.addParameter(key, value);
        return this;
    }

    public void post() {
        Map<String, String> headers;
        if (this.fields.getSize() > 0) {
            FormContentProvider formContentProvider = new FormContentProvider(this.fields);
            this.request.content((ContentProvider)formContentProvider);
        }
        if ((headers = this.getHeaders()) != null & headers.size() > 0 && headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.request.header(entry.getKey(), entry.getValue());
            }
        }
        this.request.onResponseContent((response, content) -> this.invokeCallback.success(response, content));
        this.request.onRequestFailure((request1, failure) -> this.invokeCallback.failed(request1, failure));
        ReactiveRequest reactiveRequest = ReactiveRequest.newBuilder((Request)this.request).build();
        Publisher publisher = reactiveRequest.response(ReactiveResponse.Content.discard());
        publisher.subscribe((Subscriber)new Subscriber<ReactiveResponse>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            public void onNext(ReactiveResponse response) {
                Response httpResponse = response.getResponse();
            }

            public void onError(Throwable failure) {
            }

            public void onComplete() {
            }
        });
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.signature.method(this.request.getMethod()).path(this.request.getPath()).secretKey(this.asyncExecutableClient.getSecretKey());
        String signStr = this.signature.sign();
        headers.put("apiKey", this.asyncExecutableClient.getAccessKey());
        headers.put("X-Hmac-Auth-Signature", signStr);
        headers.put("X-Hmac-Auth-Timestamp", this.signature.getTimestamp());
        headers.put("X-Hmac-Auth-Version", "1.0");
        headers.put("X-Hmac-Auth-Nonce", this.signature.getNonce());
        return headers;
    }
}

