/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.provider;

import cn.smarthse.invoice.model.InValidInvoiceParam;
import cn.smarthse.invoice.model.InvoiceKpDetailModel;
import cn.smarthse.invoice.model.InvoiceKpOrInvalidResultModel;
import cn.smarthse.invoice.model.InvoiceKpParam;
import cn.smarthse.invoice.model.InvoiceKpResultModel;
import cn.smarthse.invoice.model.QueryInvoiceResultParam;
import cn.smarthse.invoice.service.InvoiceProvider;
import cn.smarthse.invoice.service.InvoiceService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InvoiceProvideServiceImpl
implements InvoiceProvider {
    @Autowired
    private InvoiceService invoiceService;

    @Override
    public InvoiceKpOrInvalidResultModel getInvoicing(InvoiceKpParam param) {
        InvoiceKpDetailModel model = new InvoiceKpDetailModel();
        BeanUtils.copyProperties((Object)param, (Object)model);
        model.setInvoiceDetail(param.getInvoiceDetail());
        String applyResult = this.invoiceService.requestBillingNew(model);
        return (InvoiceKpOrInvalidResultModel)JSONObject.parseObject((String)applyResult, InvoiceKpOrInvalidResultModel.class);
    }

    @Override
    public InvoiceKpResultModel queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        String jsonString = this.invoiceService.queryInvoiceBySerialNumber(new QueryInvoiceResultParam(queryParam.getSerialNos(), queryParam.getOrderNos(), queryParam.getIsOfferInvoiceDetail()));
        return (InvoiceKpResultModel)JSONObject.parseObject((String)jsonString, InvoiceKpResultModel.class);
    }

    @Override
    public InvoiceKpOrInvalidResultModel inValidInvoice(InValidInvoiceParam inValidInvoiceParam) {
        String applyResult = this.invoiceService.invoiceCancellation(inValidInvoiceParam);
        return (InvoiceKpOrInvalidResultModel)JSONObject.parseObject((String)applyResult, InvoiceKpOrInvalidResultModel.class);
    }
}

