package cn.smarthse.invoice.service;

import cn.smarthse.invoice.model.*;

/**
 * 在线发票公共服务接口
 *
 * @Author Wuxq [1071592960@qq.com]
 * @Date 2021年3月1日 上午11:20:21
 */
public interface InvoiceProvider {

    /**
     * 方法描述: 开票请求接口
     *
     * @param   kpParam 开票参数对象
     * @return  InvoiceKpResultModel:成功则返回发票流水号
     * @author  wuxq
     * @date    2021/7/1
     */
    InvoiceKpOrInvalidResultModel getInvoicing(InvoiceKpParam kpParam);

    /**
     * 方法描述:  开票结果查询接口
     *
     * @param   queryParam 开票结果查询参数对象
     * @return  InvoiceKpResultModel 发票详情
     * @author  wuxq
     * @date    2021/7/1
     */
    InvoiceKpResultModel queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam);

    /**
     * 方法描述:  发票作废申请接口(当月开具有误的发票可作废，当月之前的只能开红票，也就是冲红，来抵消之前的误开票据)
     *
     * @param   inValidInvoiceParam 发票作废申请参数对象
     * @return  String 成功则返回发票请求流水号
     * @author  wuxq
     * @date    2021/7/1
     */
    InvoiceKpOrInvalidResultModel inValidInvoice(InValidInvoiceParam inValidInvoiceParam);
}
