package cn.smarthse.invoice.model;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description  发票商品明细
 * @Author Wuxq
 * @Date 10:18 2021/3/2
 **/
@Data
public class InvoiceGoodsDetailModel implements Serializable {
    
	private static final long serialVersionUID = -6466441046352340913L;

    @ApiModelProperty(value = "商品名称（如invoiceLineProperty =1，则此商品行为折扣行，折扣行不允许多行折扣，折扣行必须紧邻被折扣行，商品名称必须与被折扣行一致）",required = true)
    private String goodsName;

    @ApiModelProperty(value = "商品编码（商品税收分类编码开发者自行填写，也可不填，诺诺第三方接口自行匹配）")
    private String goodsCode;

    @ApiModelProperty(value = "自行编码（可不填）")
    private String selfCode;

    @ApiModelProperty(value = "单价含税标志，0:不含税,1:含税",required = true)
    private String withTaxFlag = "1";

    @ApiModelProperty(value = "单价，当单价(price)为空时，数量(num)也必须为空；(price)为空时，含税金额(taxIncludedAmount)、不含税金额(taxExcludedAmount)、税额(tax)都不能为空")
    private String price;

    @ApiModelProperty(value = "数量（开具红票时数量为负数）")
    private String num;

    @ApiModelProperty(value = "单位，开具成品油发票时必填，必须为”升”或“吨”。")
    private String unit;

    @ApiModelProperty(value = "规格型号")
    private String specType;

    @ApiModelProperty(value = "税额，[不含税金额] * [税率] = [税额]；税额允许误差为 0.06。红票为负。不含税金额、税额、含税金额任何一个不传时，" +
                              "会根据传入的单价，数量进行计算，可能和实际数值存在误差，建议都传入")
    private String tax;

    @ApiModelProperty(value = "税率，注：纸票清单红票存在为null的情况",required = true)
    private String taxRate = "0.01";

    @ApiModelProperty(value = "不含税金额。红票为负。不含税金额、税额、含税金额任何一个不传时，会根据传入的单价，数量进行计算，可能和实际数值存在误差，建议都传入")
    private String taxExcludedAmount;

    @ApiModelProperty(value = "含税金额，[不含税金额] + [税额] = [含税金额]，红票为负。不含税金额、税额、含税金额任何一个不传时，会根据传入的单价，数量进行计算，可能和实际数值存在误差，建议都传入")
    private String taxIncludedAmount;

    @ApiModelProperty(value = "发票行性质，0:正常行(默认);1:折扣行;2:被折扣行")
    private String invoiceLineProperty = "0";

    @ApiModelProperty(value = "优惠政策标识,0:不使用（默认）;1:使用")
    private String favouredPolicyFlag = "0";

    @ApiModelProperty(value = "增值税特殊管理（优惠政策名称）,当favouredPolicyFlag为1时，此项必填，如：即征即退、免税、简易征收等")
    private String favouredPolicyName;

    @ApiModelProperty(value = "扣除额，差额征收时填写，目前只支持填写一项。 注意：当传0、空或字段不传时，都表示非差额征税；传0.00才表示差额征税：0.00")
    private String deduction = "0";

    @ApiModelProperty(value = "零税率标识：空,非零税率;1,免税;2,不征税;3,普通零税率；" +
            "1、当税率为：0%，且增值税特殊管理：为“免税”， 零税率标识：需传“1” " +
            "2、当税率为：0%，且增值税特殊管理：为“不征税” 零税率标识：需传“2” " +
            "3、当税率为：0%，且增值税特殊管理：为空 零税率标识：需传“3”")
    private String zeroRateFlag = "";

}
