/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.service.impl;

import cn.smarthse.invoice.model.InValidInvoiceParam;
import cn.smarthse.invoice.model.InvoiceCommonParamModel;
import cn.smarthse.invoice.model.InvoiceKpDetailModel;
import cn.smarthse.invoice.model.InvoiceKpOrderModel;
import cn.smarthse.invoice.model.QueryInvoiceResultParam;
import cn.smarthse.invoice.service.InvoiceSDKService;
import cn.smarthse.invoice.service.InvoiceService;
import com.alibaba.fastjson.JSONArray;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InvoiceServiceImpl
implements InvoiceService {
    @Resource
    private InvoiceSDKService sdkService;
    @Value(value="${nuonuo.invoice.requestUrl}")
    private String requestUrl;
    @Value(value="${nuonuo.invoice.apiMethod.requestBillingNew}")
    private String requestBillingNew;
    @Value(value="${nuonuo.invoice.apiMethod.queryInvoiceResult}")
    private String queryInvoiceResult;
    @Value(value="${nuonuo.invoice.apiMethod.invoiceCancellation}")
    private String invoiceCancellation;
    @Value(value="${nuonuo.invoice.taxNum}")
    private String taxNum;
    @Value(value="${nuonuo.invoice.salerTel}")
    private String salerTel;
    @Value(value="${nuonuo.invoice.salerAddress}")
    private String salerAddress;
    @Value(value="${nuonuo.invoice.salerAccount}")
    private String salerAccount;

    @Override
    public String requestBillingNew(InvoiceKpDetailModel model) {
        model.setSalerTaxNum(this.taxNum);
        model.setSalerTel(this.salerTel);
        model.setSalerAddress(this.salerAddress);
        model.setSalerAccount(this.salerAccount);
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        InvoiceKpOrderModel orderModel = new InvoiceKpOrderModel();
        orderModel.setOrder(model);
        param.setUrl(this.requestUrl);
        param.setMethod(this.requestBillingNew);
        param.setContent(JSONArray.toJSON((Object)orderModel).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        param.setUrl(this.requestUrl);
        param.setMethod(this.queryInvoiceResult);
        param.setContent(JSONArray.toJSON((Object)queryParam).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }

    @Override
    public String invoiceCancellation(InValidInvoiceParam queryParam) {
        InvoiceCommonParamModel param = new InvoiceCommonParamModel();
        param.setUrl(this.requestUrl);
        param.setMethod(this.invoiceCancellation);
        param.setContent(JSONArray.toJSON((Object)queryParam).toString());
        return this.sdkService.sendPostSyncRequest(param);
    }
}

