/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.provider;

import cn.smarthse.invoice.model.InValidInvoiceParam;
import cn.smarthse.invoice.model.InvoiceKpDetailModel;
import cn.smarthse.invoice.model.InvoiceKpOrInvalidResultModel;
import cn.smarthse.invoice.model.InvoiceKpParam;
import cn.smarthse.invoice.model.InvoiceKpResultDetailModel;
import cn.smarthse.invoice.model.InvoiceKpResultModel;
import cn.smarthse.invoice.model.QueryInvoiceResultParam;
import cn.smarthse.invoice.service.InvoiceProvider;
import cn.smarthse.invoice.service.InvoiceService;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class InvoiceProvideServiceImpl
implements InvoiceProvider {
    @Autowired
    private InvoiceService invoiceService;

    public InvoiceKpOrInvalidResultModel getInvoicing(InvoiceKpParam param) {
        InvoiceKpDetailModel model = new InvoiceKpDetailModel();
        BeanUtils.copyProperties((Object)param, (Object)model);
        model.setInvoiceDetail(param.getInvoiceDetail());
        String applyResult = this.invoiceService.requestBillingNew(model);
        JSONObject json = JSONObject.fromObject((Object)applyResult);
        return (InvoiceKpOrInvalidResultModel)JSONObject.toBean((JSONObject)json, InvoiceKpOrInvalidResultModel.class);
    }

    public InvoiceKpResultModel queryInvoiceBySerialNumber(QueryInvoiceResultParam queryParam) {
        String jsonString = this.invoiceService.queryInvoiceBySerialNumber(new QueryInvoiceResultParam(queryParam.getSerialNos(), queryParam.getOrderNos(), queryParam.getIsOfferInvoiceDetail()));
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        HashMap<String, Class<InvoiceKpResultDetailModel>> classMap = new HashMap<String, Class<InvoiceKpResultDetailModel>>();
        classMap.put("result", InvoiceKpResultDetailModel.class);
        return (InvoiceKpResultModel)JSONObject.toBean((JSONObject)jsonObject, InvoiceKpResultModel.class, classMap);
    }

    public InvoiceKpOrInvalidResultModel inValidInvoice(InValidInvoiceParam inValidInvoiceParam) {
        String applyResult = this.invoiceService.invoiceCancellation(inValidInvoiceParam);
        JSONObject json = JSONObject.fromObject((Object)applyResult);
        return (InvoiceKpOrInvalidResultModel)JSONObject.toBean((JSONObject)json, InvoiceKpOrInvalidResultModel.class);
    }
}

