/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.interprecetor;

import cn.smarthse.invoice.util.IPUtils;
import java.io.InputStream;
import java.util.Properties;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.validation.filter.ValidationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class DubboValidFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboValidFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Properties prop = new Properties();
        InputStream in = ValidationFilter.class.getResourceAsStream("/ipwhitelist.properties");
        String clientIp = RpcContext.getContext().getRemoteHost();
        try {
            prop.load(in);
            String ipWhiteList = prop.getProperty("ip-whitelist");
            LOGGER.debug("ip\u767d\u540d\u5355\u5217\u8868\uff1a{}", (Object)ipWhiteList);
            if (IPUtils.ipIsInner(clientIp) || ipWhiteList.contains(clientIp)) {
                LOGGER.debug("\u5ba2\u6237\u7aefip\u8bbf\u95ee\u901a\u8fc7\uff1a{}", (Object)ipWhiteList);
                return invoker.invoke(invocation);
            }
            LOGGER.debug("\u5ba2\u6237\u7aefip\u8bbf\u95ee\u62d2\u7edd\uff1a{}", (Object)ipWhiteList);
            return new AppResponse((Throwable)new Exception("ip\u5730\u5740\uff1a" + clientIp + "\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff01"));
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RpcException(t.getMessage(), t);
        }
    }
}

