/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.interprecetor;

import cn.smarthse.invoice.util.IPUtils;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;

public class ApiSignInterceptor
implements HandlerInterceptor {
    @Value(value="${ip-interceptor.whitelist}")
    private String ipWhiteListStr;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String errorText = "illegal ip request!";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "POST,PUT");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
        ArrayList<String> iplist = new ArrayList<String>(Arrays.asList(this.ipWhiteListStr.split(",")));
        String httpIp = IPUtils.getRealIP(request);
        if (StringUtils.isEmpty((String)httpIp)) {
            response.sendError(404);
            return false;
        }
        boolean valid = false;
        String[] httpIps = httpIp.split(",");
        String accessIp = "";
        String[] stringArray = httpIps;
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String httpip;
            accessIp = httpip = stringArray[i];
            if (IPUtils.ipIsInner(httpip)) {
                valid = true;
                break;
            }
            for (String s : iplist) {
                if (!s.trim().equals(httpip.trim())) continue;
                valid = true;
                continue block0;
            }
        }
        if (!valid) {
            this.logger.info("IP: " + accessIp + " \u88ab\u62e6\u622a");
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(errorText);
            return false;
        }
        return true;
    }
}

