/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.bootstrap;

import cn.smarthse.invoice.interprecetor.CorsInterceptor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigInteger;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class WebConfiguration
extends WebMvcConfigurationSupport {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public void addInterceptors(InterceptorRegistry registry) {
        this.logger.info("\u914d\u7f6e \u8de8\u57df\u62e6\u622a\u5668");
        registry.addInterceptor((HandlerInterceptor)this.getCorsInterceptor()).addPathPatterns(new String[]{"/**"});
        super.addInterceptors(registry);
    }

    @Bean
    public CorsInterceptor getCorsInterceptor() {
        return new CorsInterceptor();
    }

    @Bean
    public MappingJackson2HttpMessageConverter jackson2Converter() {
        this.logger.info("\u914d\u7f6e MappingJackson2HttpMessageConverter");
        MappingJackson2HttpMessageConverter jackson2Converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jackson2Converter.setObjectMapper(objectMapper);
        return jackson2Converter;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.logger.info("\u914d\u7f6e JSON\u8f6c\u6362\u5668");
        converters.add((HttpMessageConverter<?>)this.jackson2Converter());
        super.configureMessageConverters(converters);
    }
}

