/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.invoice.bootstrap;

import cn.smarthse.invoice.bootstrap.BaseConfiguration;
import cn.smarthse.invoice.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.invoice.config.SpringContextHolder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={TaskExecutorProperties.class})
public class ContentConfiguration
extends BaseConfiguration {
    private final TaskExecutorProperties taskExecutorProperties;

    @Bean
    public ThreadPoolTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> this.logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u7ebf\u7a0b\u62d2\u7edd\u6267\u884c\uff1a{}", (Object)r.toString()));
        executor.initialize();
        return executor;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    public ContentConfiguration(TaskExecutorProperties taskExecutorProperties) {
        this.taskExecutorProperties = taskExecutorProperties;
    }
}

