/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;

@Order(value=1)
public class WcspSecurityFilter
implements Filter {
    private Map<String, String> keySecret;

    public WcspSecurityFilter(Map<String, String> keySecret) {
        this.keySecret = keySecret;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!this.validateSecurityHeaders(httpRequest, httpResponse)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean validateSecurityHeaders(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String apiKey = request.getHeader("X-API-Key");
        String timestamp = request.getHeader("X-Timestamp");
        String signature = request.getHeader("X-Signature");
        String data = request.getParameter("dataX");
        if (StrUtil.isBlank((CharSequence)apiKey) || StrUtil.isBlank((CharSequence)timestamp) || StrUtil.isBlank((CharSequence)signature) || StrUtil.isBlank((CharSequence)data)) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.getWriter().write("\u7f3a\u5c11\u5fc5\u8981\u7684\u5b89\u5168\u9a8c\u8bc1\u53c2\u6570");
            return false;
        }
        try {
            long requestTime = Long.parseLong(timestamp);
            long currentTime = System.currentTimeMillis();
            if (Math.abs(currentTime - requestTime) > 300000L) {
                response.setStatus(HttpStatus.BAD_REQUEST.value());
                response.getWriter().write("\u8bf7\u6c42\u5df2\u8fc7\u671f");
                return false;
            }
        }
        catch (NumberFormatException e) {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.getWriter().write("\u65f6\u95f4\u6233\u683c\u5f0f\u9519\u8bef");
            return false;
        }
        String secretKey = this.getSecretKeyByApiKey(apiKey);
        if (StrUtil.isBlank((CharSequence)secretKey)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.getWriter().write("\u65e0\u6548\u7684API Key");
            return false;
        }
        String expectedSignature = SecureUtil.sha256((String)(data + timestamp + secretKey));
        if (!expectedSignature.equals(signature)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.getWriter().write("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            return false;
        }
        return true;
    }

    private String getSecretKeyByApiKey(String apiKey) {
        return this.keySecret.get(apiKey);
    }
}

