/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.esservice;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.extend.wcsp.dao.DataEncryptMapper;
import cn.smarthse.extend.wcsp.document.SysDataEncryptDocument;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocumentMapper;
import cn.smarthse.extend.wcsp.model.EncryptResult;
import cn.smarthse.extend.wcsp.model.SysDataEncryptParam;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.xxl.job.core.context.XxlJobHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.easyes.core.conditions.select.LambdaEsQueryWrapper;
import org.dromara.easyes.core.kernel.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class SysDataEncryptDocumentManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysDataEncryptDocumentManager.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final DataEncryptMapper dataEncryptMapper;
    private final SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper;
    private static final int BATCH_SIZE = 10000;
    private static final int CONCURRENT_THREADS = 8;
    private static final int ES_BATCH_SIZE = 1200;
    private static final int MAX_ORIGINAL_DATA_LENGTH = 512;
    private final Cache<String, String> encryptCache = Caffeine.newBuilder().maximumSize(200000L).expireAfterWrite(30L, TimeUnit.MINUTES).expireAfterAccess(15L, TimeUnit.MINUTES).recordStats().build();

    public List<SysDataEncryptDocument> search(SysDataEncryptParam param) {
        LambdaEsQueryWrapper wrapper = (LambdaEsQueryWrapper)new LambdaEsQueryWrapper().in(CollUtil.isNotEmpty(param.getOriginalDataList()), SysDataEncryptDocument::getOriginalData, param.getOriginalDataList());
        return this.sysDataEncryptDocumentMapper.selectList((Wrapper)wrapper);
    }

    private void logCacheStats() {
        CacheStats stats = this.encryptCache.stats();
        long cacheSize = this.encryptCache.estimatedSize();
        String message = String.format("\u7f13\u5b58\u7edf\u8ba1\u4fe1\u606f - \u5f53\u524d\u5927\u5c0f: %d, \u603b\u8bf7\u6c42\u6570: %d, \u547d\u4e2d\u6570: %d, \u672a\u547d\u4e2d\u6570: %d, \u547d\u4e2d\u7387: %.2f%%, \u52a0\u8f7d\u6210\u529f\u6570: %d, \u52a0\u8f7d\u5931\u8d25\u6570: %d", cacheSize, stats.requestCount(), stats.hitCount(), stats.missCount(), stats.hitRate() * 100.0, stats.loadSuccessCount(), stats.loadFailureCount());
        log.info(message);
        XxlJobHelper.log((String)message, (Object[])new Object[0]);
    }

    private void logMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        long availableMemory = maxMemory - (totalMemory - freeMemory);
        double usagePercentage = (double)usedMemory / (double)maxMemory * 100.0;
        double heapUsagePercentage = (double)usedMemory / (double)totalMemory * 100.0;
        String message = String.format("\u5185\u5b58\u4f7f\u7528\u60c5\u51b5 - \u5df2\u4f7f\u7528: %dMB, \u5806\u5185\u5b58: %dMB, \u6700\u5927\u5806: %dMB, \u5806\u4f7f\u7528\u7387: %.2f%%, \u603b\u4f53\u4f7f\u7528\u7387: %.2f%%, \u53ef\u7528\u5185\u5b58: %dMB", usedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, maxMemory / 1024L / 1024L, heapUsagePercentage, usagePercentage, availableMemory / 1024L / 1024L);
        log.info(message);
        XxlJobHelper.log((String)message, (Object[])new Object[0]);
    }

    public void batchEncryptData(String databaseName, String tableName, String idColumn, String dataColumn, String idType) {
        AtomicInteger totalSuccess = new AtomicInteger(0);
        AtomicInteger totalFail = new AtomicInteger(0);
        int batchNumber = 0;
        List<Object> failedIds = Collections.synchronizedList(new ArrayList());
        log.info("\u5f00\u59cb\u6279\u91cf\u52a0\u5bc6\u6570\u636e\uff0c\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0c\u5b57\u6bb5:{}", new Object[]{databaseName, tableName, dataColumn});
        XxlJobHelper.log((String)"\u5f00\u59cb\u6279\u91cf\u52a0\u5bc6\u6570\u636e\uff0c\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0c\u5b57\u6bb5:{}", (Object[])new Object[]{databaseName, tableName, dataColumn});
        boolean isStringId = "string".equals(idType);
        long lastPosition = 0L;
        try {
            List<EncryptResult> dataList;
            while (!(dataList = isStringId ? this.dataEncryptMapper.selectDataToEncryptString(databaseName, tableName, idColumn, dataColumn, lastPosition, 10000) : this.dataEncryptMapper.selectDataToEncryptNumber(databaseName, tableName, idColumn, dataColumn, lastPosition, 10000)).isEmpty()) {
                log.info("\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0c\u5b57\u6bb5:{}\uff0c\u5f00\u59cb\u5904\u7406\u7b2c{}\u6279\u6570\u636e\uff0c\u5171{}\u6761", new Object[]{databaseName, tableName, dataColumn, ++batchNumber, dataList.size()});
                XxlJobHelper.log((String)"\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0c\u5b57\u6bb5:{}\uff0c\u5f00\u59cb\u5904\u7406\u7b2c{}\u6279\u6570\u636e\uff0c\u5171{}\u6761", (Object[])new Object[]{databaseName, tableName, dataColumn, batchNumber, dataList.size()});
                lastPosition = isStringId ? (lastPosition += (long)dataList.size()) : dataList.stream().map(EncryptResult::getId).filter(Objects::nonNull).mapToLong(id -> {
                    if (id instanceof Number) {
                        return ((Number)id).longValue();
                    }
                    throw new RuntimeException("ID\u8f6c\u6362\u5931\u8d25");
                }).max().orElse(lastPosition);
                List<List<EncryptResult>> partitions = this.partitionList(dataList);
                if (partitions.size() == 1) {
                    this.processPartition(partitions.get(0), idColumn, dataColumn, databaseName, tableName, totalSuccess, totalFail, failedIds);
                } else {
                    CountDownLatch latch = new CountDownLatch(partitions.size());
                    for (List<EncryptResult> partition : partitions) {
                        this.threadPoolTaskExecutor.execute(() -> {
                            try {
                                this.processPartition(partition, idColumn, dataColumn, databaseName, tableName, totalSuccess, totalFail, failedIds);
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                    }
                    latch.await();
                }
                log.info("\u7b2c{}\u6279\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f:{}\uff0c\u5931\u8d25:{}", new Object[]{batchNumber, totalSuccess.get(), totalFail.get()});
                XxlJobHelper.log((String)"\u7b2c{}\u6279\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f:{}\uff0c\u5931\u8d25:{}", (Object[])new Object[]{batchNumber, totalSuccess.get(), totalFail.get()});
            }
            this.logCacheStats();
            this.logMemoryUsage();
            log.info("\u6240\u6709\u6570\u636e\u5904\u7406\u5b8c\u6210\uff0c\u603b\u6279\u6b21\u6570:{}\uff0c\u603b\u6210\u529f:{}\uff0c\u603b\u5931\u8d25:{}", new Object[]{batchNumber, totalSuccess.get(), totalFail.get()});
            XxlJobHelper.log((String)"\u6240\u6709\u6570\u636e\u5904\u7406\u5b8c\u6210\uff0c\u603b\u6279\u6b21\u6570:{}\uff0c\u603b\u6210\u529f:{}\uff0c\u603b\u5931\u8d25:{}", (Object[])new Object[]{batchNumber, totalSuccess.get(), totalFail.get()});
            if (!failedIds.isEmpty()) {
                this.generateAndLogNullifySql(databaseName, tableName, idColumn, dataColumn, failedIds);
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u52a0\u5bc6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            XxlJobHelper.log((String)"\u6279\u91cf\u52a0\u5bc6\u5904\u7406\u5f02\u5e38: {}", (Object[])new Object[]{e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    private void processPartition(List<EncryptResult> partition, String idColumn, String dataColumn, String databaseName, String tableName, AtomicInteger totalSuccess, AtomicInteger totalFail, List<Object> failedIds) {
        try {
            List originalDataList = partition.stream().map(EncryptResult::getData).filter(this::shouldEncrypt).map(String::trim).distinct().collect(Collectors.toList());
            HashMap<String, String> encryptedDataMap = new HashMap<String, String>();
            ArrayList<String> needToQueryFromES = new ArrayList<String>();
            for (String originalData : originalDataList) {
                String cached = (String)this.encryptCache.getIfPresent((Object)originalData);
                if (cached != null) {
                    encryptedDataMap.put(originalData, cached);
                    continue;
                }
                needToQueryFromES.add(originalData);
            }
            if (!needToQueryFromES.isEmpty()) {
                Map<String, String> esResults = this.batchGetEncryptedDataFromES(needToQueryFromES);
                encryptedDataMap.putAll(esResults);
                esResults.forEach((arg_0, arg_1) -> this.encryptCache.put(arg_0, arg_1));
            }
            ArrayList<EncryptResult> encryptResults = new ArrayList<EncryptResult>(partition.size());
            ArrayList<SysDataEncryptDocument> newDocuments = new ArrayList<SysDataEncryptDocument>();
            for (EncryptResult data : partition) {
                Object id = data.getId();
                String originalData = data.getData();
                try {
                    if (!this.shouldEncrypt(originalData)) {
                        encryptResults.add(new EncryptResult(id, originalData));
                        totalSuccess.incrementAndGet();
                        continue;
                    }
                    String encryptedData = (String)encryptedDataMap.get(originalData = originalData.trim());
                    if (encryptedData == null) {
                        byte[] originalDataBytes;
                        encryptedData = (String)this.encryptCache.getIfPresent((Object)originalData);
                        if (encryptedData == null) {
                            encryptedData = SpringEncryptUtils.encrypt((String)originalData);
                            this.encryptCache.put((Object)originalData, (Object)encryptedData);
                        }
                        if ((originalDataBytes = originalData.getBytes(StandardCharsets.UTF_8)).length <= 512) {
                            SysDataEncryptDocument document = new SysDataEncryptDocument();
                            document.setOriginalData(originalData);
                            document.setEncryptData(encryptedData);
                            newDocuments.add(document);
                        } else {
                            log.warn("\u539f\u59cb\u6570\u636e\u957f\u5ea6\u8d85\u9650\uff0c\u8df3\u8fc7ES\u5b58\u50a8\u3002\u957f\u5ea6: {}", (Object)originalDataBytes.length);
                        }
                    }
                    encryptResults.add(new EncryptResult(id, encryptedData));
                    totalSuccess.incrementAndGet();
                }
                catch (Exception e) {
                    log.error("\u52a0\u5bc6\u5931\u8d25\uff0c\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0cID\u5b57\u6bb5:{}\uff0c\u6570\u636e\u5b57\u6bb5:{}\uff0cID:{}\uff0c\u6570\u636e:{}", new Object[]{databaseName, tableName, idColumn, dataColumn, id, originalData, e});
                    XxlJobHelper.log((String)"\u52a0\u5bc6\u5931\u8d25\uff0c\u6570\u636e\u5e93:{}\uff0c\u8868:{}\uff0cID\u5b57\u6bb5:{}\uff0c\u6570\u636e\u5b57\u6bb5:{}\uff0cID:{}\uff0c\u6570\u636e:{}\uff0c\u5f02\u5e38:{}", (Object[])new Object[]{databaseName, tableName, idColumn, dataColumn, id, originalData, e.getMessage()});
                    totalFail.incrementAndGet();
                    failedIds.add(id);
                }
            }
            if (!encryptResults.isEmpty()) {
                this.dataEncryptMapper.batchUpdateEncryptedData(databaseName, tableName, idColumn, dataColumn, encryptResults);
            }
            if (!newDocuments.isEmpty()) {
                this.batchInsertEncryptedDataToES(newDocuments);
            }
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u5904\u7406\u5f02\u5e38", (Throwable)e);
            XxlJobHelper.log((String)"\u5206\u7247\u5904\u7406\u5f02\u5e38: {}", (Object[])new Object[]{e.getMessage()});
        }
    }

    private boolean shouldEncrypt(String data) {
        return StrUtil.isNotBlank((CharSequence)data) && !StrUtil.startWith((CharSequence)data.trim(), (CharSequence)"VI*D#S") && !data.trim().isEmpty();
    }

    private Map<String, String> batchGetEncryptedDataFromES(List<String> originalDataList) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (originalDataList.isEmpty()) {
            return result;
        }
        try {
            for (int i = 0; i < originalDataList.size(); i += 1200) {
                int endIndex = Math.min(i + 1200, originalDataList.size());
                List<String> batchList = originalDataList.subList(i, endIndex);
                List<SysDataEncryptDocument> list = this.search(new SysDataEncryptParam(batchList));
                if (!CollUtil.isNotEmpty(list)) continue;
                for (SysDataEncryptDocument document : list) {
                    result.put(document.getOriginalData(), document.getEncryptData());
                }
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u67e5\u8be2ES\u52a0\u5bc6\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u6761\u6570:{}", (Object)originalDataList.size(), (Object)e);
            XxlJobHelper.log((String)"\u6279\u91cf\u67e5\u8be2ES\u52a0\u5bc6\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u6761\u6570:{}\uff0c\u5f02\u5e38:{}", (Object[])new Object[]{originalDataList.size(), e.getMessage()});
        }
        return result;
    }

    private void batchInsertEncryptedDataToES(List<SysDataEncryptDocument> documents) {
        if (documents.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < documents.size(); i += 1200) {
                int endIndex = Math.min(i + 1200, documents.size());
                List<SysDataEncryptDocument> batchList = documents.subList(i, endIndex);
                Integer insertCount = this.sysDataEncryptDocumentMapper.insertBatch(batchList);
                log.info("\u6279\u91cf\u63d2\u5165ES\u52a0\u5bc6\u6570\u636e\u6210\u529f\uff0c\u6761\u6570:{}\uff0c\u5b9e\u9645\u6761\u6570:{}", (Object)batchList.size(), (Object)insertCount);
                XxlJobHelper.log((String)"\u6279\u91cf\u63d2\u5165ES\u52a0\u5bc6\u6570\u636e\u6210\u529f\uff0c\u6761\u6570:{}\uff0c\u5b9e\u9645\u6761\u6570:{}", (Object[])new Object[]{batchList.size(), insertCount});
            }
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d2\u5165ES\u52a0\u5bc6\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u6761\u6570:{}", (Object)documents.size(), (Object)e);
            XxlJobHelper.log((String)"\u6279\u91cf\u63d2\u5165ES\u52a0\u5bc6\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u6761\u6570:{}\uff0c\u5f02\u5e38:{}", (Object[])new Object[]{documents.size(), e.getMessage()});
        }
    }

    private <T> List<List<T>> partitionList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() <= 8) {
            return Collections.singletonList(list);
        }
        int partitionCount = Math.min(8, list.size());
        int partitionSize = (int)Math.ceil((double)list.size() / (double)partitionCount);
        ArrayList<List<T>> partitions = new ArrayList<List<T>>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            int start = i * partitionSize;
            int end = Math.min(start + partitionSize, list.size());
            if (start >= end) continue;
            partitions.add(list.subList(start, end));
        }
        return partitions;
    }

    private void generateAndLogNullifySql(String databaseName, String tableName, String idColumn, String dataColumn, List<Object> failedIds) {
        if (failedIds.isEmpty()) {
            return;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("-- \u4ee5\u4e0bSQL\u7528\u4e8e\u7f6e\u7a7a\u52a0\u5bc6\u5931\u8d25\u7684\u6570\u636e\n");
        for (Object id : failedIds) {
            Object idValue = id instanceof String ? "'" + String.valueOf(id) + "'" : String.valueOf(id);
            sqlBuilder.append(String.format("UPDATE `%s`.`%s` SET `%s` = NULL WHERE `%s` = %s;\n", databaseName, tableName, dataColumn, idColumn, idValue));
        }
        String sqlStatements = sqlBuilder.toString();
        log.warn("\u751f\u6210\u7f6e\u7a7aSQL\u8bed\u53e5:\n{}", (Object)sqlStatements);
        XxlJobHelper.log((String)"\u751f\u6210\u7f6e\u7a7aSQL\u8bed\u53e5:\n{}", (Object[])new Object[]{sqlStatements});
    }

    @Generated
    public SysDataEncryptDocumentManager(ThreadPoolTaskExecutor threadPoolTaskExecutor, DataEncryptMapper dataEncryptMapper, SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.dataEncryptMapper = dataEncryptMapper;
        this.sysDataEncryptDocumentMapper = sysDataEncryptDocumentMapper;
    }
}

