/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.esservice;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.extend.wcsp.document.SysDataEncryptDocument;
import cn.smarthse.extend.wcsp.document.SysDataEncryptDocument3;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocument3Mapper;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocumentMapper;
import cn.smarthse.framework.core.utils.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.dromara.easyes.core.biz.SAPageInfo;
import org.dromara.easyes.core.conditions.select.LambdaEsQueryWrapper;
import org.dromara.easyes.core.kernel.EsWrappers;
import org.dromara.easyes.core.kernel.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDataEncryptDocument3Manager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysDataEncryptDocument3Manager.class);
    private final FieldEncryptorProperties fieldEncryptorProperties;
    private final SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper;
    private final SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper;

    public void migrateDataWithPagination() {
        LocalDateTime now = LocalDateTime.now();
        int pageSize = 10000;
        int pageNum = 1;
        long totalMigrated = 0L;
        log.info("\u5f00\u59cb\u6570\u636e\u8fc1\u79fb\uff0c\u5206\u9875\u5927\u5c0f: {}", (Object)pageSize);
        XxlJobHelper.log((String)"\u5f00\u59cb\u6570\u636e\u8fc1\u79fb\uff0c\u5206\u9875\u5927\u5c0f: {}", (Object[])new Object[]{pageSize});
        XxlJobHelper.log((String)"\u5f00\u59cb\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\uff0c\u6bcf\u9875{}\u6761", (Object[])new Object[]{pageNum, pageSize});
        LambdaEsQueryWrapper lambdaEsQueryWrapper = EsWrappers.lambdaQuery(SysDataEncryptDocument.class);
        lambdaEsQueryWrapper.size(Integer.valueOf(pageSize));
        lambdaEsQueryWrapper.orderByDesc(SysDataEncryptDocument::getOriginalData);
        List searchAfter = null;
        boolean hasMoreData = true;
        while (hasMoreData) {
            SAPageInfo oldDocuments;
            try {
                oldDocuments = this.sysDataEncryptDocumentMapper.searchAfterPage((Wrapper)lambdaEsQueryWrapper, searchAfter, pageSize);
                XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u5b8c\u6210\uff0c\u83b7\u53d6\u5230{}\u6761\u8bb0\u5f55", (Object[])new Object[]{pageNum, oldDocuments.getList() != null ? oldDocuments.getList().size() : 0});
                searchAfter = oldDocuments.getNextSearchAfter();
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25", (Object)pageNum, (Object)e);
                XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25: {}", (Object[])new Object[]{pageNum, e.getMessage()});
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u9875\u7801: " + pageNum, e);
            }
            if (oldDocuments.getList() == null || oldDocuments.getList().isEmpty()) {
                XxlJobHelper.log((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7ed3\u675f\u6570\u636e\u8fc1\u79fb", (Object[])new Object[0]);
                break;
            }
            ArrayList<SysDataEncryptDocument3> newDocuments = new ArrayList<SysDataEncryptDocument3>(oldDocuments.getList().size());
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406\u7b2c{}\u9875\u7684{}\u6761\u6570\u636e", (Object[])new Object[]{pageNum, oldDocuments.getList().size()});
            String password = this.fieldEncryptorProperties.getMaxVersionGroupConfig().getPassword();
            int processedCount = 0;
            for (SysDataEncryptDocument oldDoc : oldDocuments.getList()) {
                try {
                    SysDataEncryptDocument3 newDoc = new SysDataEncryptDocument3();
                    newDoc.setPlaintext(EncryptUtils.encryptBySm4((String)oldDoc.getOriginalData(), (String)password));
                    newDoc.setCiphertext(oldDoc.getEncryptData());
                    newDocuments.add(newDoc);
                    if (++processedCount % 2000 != 0) continue;
                    XxlJobHelper.log((String)"\u5df2\u5904\u7406\u7b2c{}\u9875\u4e2d\u7684{}\u6761\u6570\u636e", (Object[])new Object[]{pageNum, processedCount});
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u6570\u636e\u5931\u8d25\uff0coriginalData: {}", (Object)oldDoc.getOriginalData(), (Object)e);
                    XxlJobHelper.log((String)"\u5904\u7406\u6570\u636e\u5931\u8d25\uff0coriginalData: {}, \u9519\u8bef: {}", (Object[])new Object[]{oldDoc.getOriginalData(), e.getMessage()});
                }
            }
            XxlJobHelper.log((String)"\u7b2c{}\u9875\u6570\u636e\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f\u5904\u7406{}\u6761\u6570\u636e", (Object[])new Object[]{pageNum, processedCount});
            if (!newDocuments.isEmpty()) {
                try {
                    XxlJobHelper.log((String)"\u5f00\u59cb\u63d2\u5165\u7b2c{}\u9875\u7684{}\u6761\u6570\u636e\u5230\u65b0\u7d22\u5f15", (Object[])new Object[]{pageNum, newDocuments.size()});
                    Integer inserted = this.insertBatch(newDocuments);
                    log.info("\u7b2c{}\u9875\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\uff0c\u672c\u9875\u8fc1\u79fb: {} \u6761, \u7d2f\u8ba1\u8fc1\u79fb: {} \u6761", new Object[]{pageNum, newDocuments.size(), totalMigrated += (long)newDocuments.size()});
                    XxlJobHelper.log((String)"\u7b2c{}\u9875\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\uff0c\u672c\u9875\u8fc1\u79fb: {} \u6761, \u7d2f\u8ba1\u8fc1\u79fb: {} \u6761\uff0c\u5b9e\u9645\u63d2\u5165: {} \u6761", (Object[])new Object[]{pageNum, newDocuments.size(), totalMigrated, inserted});
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165\u7b2c{}\u9875\u6570\u636e\u5931\u8d25", (Object)pageNum, (Object)e);
                    XxlJobHelper.log((String)"\u63d2\u5165\u7b2c{}\u9875\u6570\u636e\u5931\u8d25: {}", (Object[])new Object[]{pageNum, e.getMessage()});
                    throw new RuntimeException("\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0c\u9875\u7801: " + pageNum, e);
                }
            } else {
                XxlJobHelper.log((String)"\u7b2c{}\u9875\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u6570\u636e", (Object[])new Object[]{pageNum});
            }
            if (oldDocuments.getList().size() < pageSize) {
                XxlJobHelper.log((String)"\u5f53\u524d\u9875\u6570\u636e\u5c11\u4e8e\u9875\u9762\u5927\u5c0f({})\uff0c\u7ed3\u675f\u6570\u636e\u8fc1\u79fb", (Object[])new Object[]{pageSize});
                hasMoreData = false;
            } else {
                XxlJobHelper.log((String)"\u5f53\u524d\u9875\u6570\u636e\u7b49\u4e8e\u9875\u9762\u5927\u5c0f\uff0c\u7ee7\u7eed\u67e5\u8be2\u4e0b\u4e00\u9875", (Object[])new Object[0]);
                hasMoreData = true;
            }
            ++pageNum;
        }
        log.info("\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\uff0c\u603b\u5171\u8fc1\u79fb {} \u6761\u8bb0\u5f55", (Object)totalMigrated);
        XxlJobHelper.log((String)"\u6570\u636e\u8fc1\u79fb\u5b8c\u6210\uff0c\u603b\u5171\u8fc1\u79fb {} \u6761\u8bb0\u5f55", (Object[])new Object[]{totalMigrated});
    }

    public Integer insertBatch(List<SysDataEncryptDocument3> documentList) {
        if (CollUtil.isEmpty(documentList)) {
            XxlJobHelper.log((String)"\u5f85\u63d2\u5165\u7684\u6587\u6863\u5217\u8868\u4e3a\u7a7a", (Object[])new Object[0]);
            return 0;
        }
        ArrayList<SysDataEncryptDocument3> documentsToInsert = new ArrayList<SysDataEncryptDocument3>();
        int duplicateCount = 0;
        int conflictCount = 0;
        XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406 {} \u6761\u5f85\u63d2\u5165\u8bb0\u5f55", (Object[])new Object[]{documentList.size()});
        for (int i = 0; i < documentList.size(); ++i) {
            SysDataEncryptDocument3 existingByCiphertext;
            SysDataEncryptDocument3 document = documentList.get(i);
            String plaintext = document.getPlaintext();
            String ciphertext = document.getCiphertext();
            if (StringUtils.isBlank((CharSequence)plaintext) || StringUtils.isBlank((CharSequence)ciphertext)) {
                log.warn("\u8df3\u8fc7\u7a7a\u7684\u660e\u6587\u6216\u5bc6\u6587\u8bb0\u5f55: plaintext={}, ciphertext={}", (Object)plaintext, (Object)ciphertext);
                XxlJobHelper.log((String)"\u8df3\u8fc7\u7a7a\u7684\u660e\u6587\u6216\u5bc6\u6587\u8bb0\u5f55: plaintext={}, ciphertext={}", (Object[])new Object[]{plaintext, ciphertext});
                continue;
            }
            boolean shouldInsert = true;
            SysDataEncryptDocument3 existingByPlaintext = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectOne((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getPlaintext, (Object)plaintext));
            if (existingByPlaintext != null) {
                if (!ciphertext.equals(existingByPlaintext.getCiphertext())) {
                    log.error("\u660e\u6587\u51b2\u7a81: \u660e\u6587 '{}' \u5df2\u5b58\u5728\u4f46\u5bf9\u5e94\u4e0d\u540c\u7684\u5bc6\u6587\u3002\u73b0\u6709\u5bc6\u6587: '{}', \u65b0\u5bc6\u6587: '{}'", new Object[]{plaintext, existingByPlaintext.getCiphertext(), ciphertext});
                    XxlJobHelper.log((String)"\u660e\u6587\u51b2\u7a81: \u660e\u6587 '{}' \u5df2\u5b58\u5728\u4f46\u5bf9\u5e94\u4e0d\u540c\u7684\u5bc6\u6587\u3002\u73b0\u6709\u5bc6\u6587: '{}', \u65b0\u5bc6\u6587: '{}'", (Object[])new Object[]{plaintext, existingByPlaintext.getCiphertext(), ciphertext});
                    ++conflictCount;
                } else {
                    log.debug("\u8df3\u8fc7\u91cd\u590d\u7684\u660e\u6587\u8bb0\u5f55: plaintext={}", (Object)plaintext);
                    XxlJobHelper.log((String)"\u8df3\u8fc7\u91cd\u590d\u7684\u660e\u6587\u8bb0\u5f55: plaintext={}", (Object[])new Object[]{plaintext});
                    ++duplicateCount;
                }
                shouldInsert = false;
            }
            if (shouldInsert && (existingByCiphertext = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectOne((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getCiphertext, (Object)ciphertext))) != null) {
                if (!plaintext.equals(existingByCiphertext.getPlaintext())) {
                    log.error("\u5bc6\u6587\u51b2\u7a81: \u5bc6\u6587 '{}' \u5df2\u5b58\u5728\u4f46\u5bf9\u5e94\u4e0d\u540c\u7684\u660e\u6587\u3002\u73b0\u6709\u660e\u6587: '{}', \u65b0\u660e\u6587: '{}'", new Object[]{ciphertext, existingByCiphertext.getPlaintext(), plaintext});
                    XxlJobHelper.log((String)"\u5bc6\u6587\u51b2\u7a81: \u5bc6\u6587 '{}' \u5df2\u5b58\u5728\u4f46\u5bf9\u5e94\u4e0d\u540c\u7684\u660e\u6587\u3002\u73b0\u6709\u660e\u6587: '{}', \u65b0\u660e\u6587: '{}'", (Object[])new Object[]{ciphertext, existingByCiphertext.getPlaintext(), plaintext});
                    ++conflictCount;
                } else {
                    log.debug("\u8df3\u8fc7\u91cd\u590d\u7684\u5bc6\u6587\u8bb0\u5f55: ciphertext={}", (Object)ciphertext);
                    XxlJobHelper.log((String)"\u8df3\u8fc7\u91cd\u590d\u7684\u5bc6\u6587\u8bb0\u5f55: ciphertext={}", (Object[])new Object[]{ciphertext});
                    ++duplicateCount;
                }
                shouldInsert = false;
            }
            if (shouldInsert) {
                documentsToInsert.add(document);
            }
            if ((i + 1) % 1000 != 0 && i + 1 != documentList.size()) continue;
            XxlJobHelper.log((String)"\u5df2\u5904\u7406 {}/{} \u6761\u8bb0\u5f55\uff0c\u5f53\u524d\u5f85\u63d2\u5165: {} \u6761\uff0c\u91cd\u590d: {} \u6761\uff0c\u51b2\u7a81: {} \u6761", (Object[])new Object[]{i + 1, documentList.size(), documentsToInsert.size(), duplicateCount, conflictCount});
        }
        if (documentsToInsert.isEmpty()) {
            log.info("\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u65b0\u8bb0\u5f55\u3002\u91cd\u590d\u8bb0\u5f55: {} \u6761, \u51b2\u7a81\u8bb0\u5f55: {} \u6761", (Object)duplicateCount, (Object)conflictCount);
            XxlJobHelper.log((String)"\u6ca1\u6709\u9700\u8981\u63d2\u5165\u7684\u65b0\u8bb0\u5f55\u3002\u91cd\u590d\u8bb0\u5f55: {} \u6761, \u51b2\u7a81\u8bb0\u5f55: {} \u6761", (Object[])new Object[]{duplicateCount, conflictCount});
            return 0;
        }
        log.info("\u51c6\u5907\u63d2\u5165 {} \u6761\u65b0\u8bb0\u5f55\uff0c\u8df3\u8fc7 {} \u6761\u8bb0\u5f55 (\u91cd\u590d: {} \u6761, \u51b2\u7a81: {} \u6761)", new Object[]{documentsToInsert.size(), duplicateCount + conflictCount, duplicateCount, conflictCount});
        XxlJobHelper.log((String)"\u51c6\u5907\u63d2\u5165 {} \u6761\u65b0\u8bb0\u5f55\uff0c\u8df3\u8fc7 {} \u6761\u8bb0\u5f55 (\u91cd\u590d: {} \u6761, \u51b2\u7a81: {} \u6761)", (Object[])new Object[]{documentsToInsert.size(), duplicateCount + conflictCount, duplicateCount, conflictCount});
        try {
            XxlJobHelper.log((String)"\u5f00\u59cb\u6279\u91cf\u63d2\u5165 {} \u6761\u8bb0\u5f55\u5230\u6570\u636e\u5e93", (Object[])new Object[]{documentsToInsert.size()});
            Integer result = this.sysDataEncryptDocument3Mapper.insertBatch(documentsToInsert);
            log.info("\u6210\u529f\u63d2\u5165 {} \u6761\u8bb0\u5f55", (Object)(result != null ? result : 0));
            XxlJobHelper.log((String)"\u6210\u529f\u63d2\u5165 {} \u6761\u8bb0\u5f55", (Object[])new Object[]{result != null ? result : 0});
            return result;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff0c\u51c6\u5907\u63d2\u5165 {} \u6761\u8bb0\u5f55", (Object)documentsToInsert.size(), (Object)e);
            XxlJobHelper.log((String)"\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff0c\u51c6\u5907\u63d2\u5165 {} \u6761\u8bb0\u5f55\uff0c\u9519\u8bef: {}", (Object[])new Object[]{documentsToInsert.size(), e.getMessage()});
            throw e;
        }
    }

    @Generated
    public SysDataEncryptDocument3Manager(FieldEncryptorProperties fieldEncryptorProperties, SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper, SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper) {
        this.fieldEncryptorProperties = fieldEncryptorProperties;
        this.sysDataEncryptDocumentMapper = sysDataEncryptDocumentMapper;
        this.sysDataEncryptDocument3Mapper = sysDataEncryptDocument3Mapper;
    }
}

