/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.controller;

import cn.smarthse.extend.wcsp.provider.HZEsEncryptServiceProviderImpl;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dubbo"})
public class DubboController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DubboController.class);
    private final HZEsEncryptServiceProviderImpl hZEsEncryptServiceProviderImpl;

    @GetMapping(value={"getCiphertext"})
    public ResponseEntity<String> getCiphertext(@RequestParam String plaintext) {
        try {
            String encrypt = this.hZEsEncryptServiceProviderImpl.getCiphertext(plaintext);
            log.info("getCiphertext\u6210\u529f: {}", (Object)encrypt);
            return ResponseEntity.ok((Object)encrypt);
        }
        catch (Exception e) {
            log.error("getCiphertext\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("getCiphertext\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"getPlaintext"})
    public ResponseEntity<String> getPlaintext(@RequestParam String ciphertext) {
        try {
            String decrypt = this.hZEsEncryptServiceProviderImpl.getPlaintext(ciphertext);
            log.info("getPlaintext\u6210\u529f: {}", (Object)decrypt);
            return ResponseEntity.ok((Object)decrypt);
        }
        catch (Exception e) {
            log.error("getPlaintext\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("getPlaintext\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"addCiphertext"})
    public ResponseEntity<String> addCiphertext(@RequestParam String plaintext, @RequestParam String ciphertext) {
        try {
            this.hZEsEncryptServiceProviderImpl.addCiphertext(plaintext, ciphertext);
            return ResponseEntity.ok((Object)"success");
        }
        catch (Exception e) {
            log.error("addCiphertext\u5931\u8d25: ", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("addCiphertext\u5931\u8d25: " + e.getMessage()));
        }
    }

    @Generated
    public DubboController(HZEsEncryptServiceProviderImpl hZEsEncryptServiceProviderImpl) {
        this.hZEsEncryptServiceProviderImpl = hZEsEncryptServiceProviderImpl;
    }
}

