/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.config;

import cn.smarthse.encrypt.context.WcspEncryptContext;
import cn.smarthse.encrypt.pool.WcspCryptoServicePlatformPool;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.spring.properties.RocksDBConfig;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.extend.wcsp.config.properties.ApiProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FieldEncryptorProperties.class, ApiProperties.class})
public class WcspConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspConfig.class);
    private final ApiProperties apiProperties;
    private final FieldEncryptorProperties fieldEncryptionProperties;

    @Bean(destroyMethod="close")
    public WcspCryptoServicePlatformPool wcspCryptoServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptUtils \u914d\u7f6e");
        WcspEncryptContext context = new WcspEncryptContext();
        context.setUrl(this.fieldEncryptionProperties.getWcspUrl());
        context.setTenantId(this.fieldEncryptionProperties.getWcspTenantId());
        context.setAppId(this.fieldEncryptionProperties.getWcspAppId());
        context.setSecret(this.fieldEncryptionProperties.getWcspSecret());
        context.setWorkDir(this.fieldEncryptionProperties.getWcspWorkDir());
        context.setPoolMaxTotal(this.fieldEncryptionProperties.getWcspPoolMaxTotal());
        context.setPoolMaxIdle(this.fieldEncryptionProperties.getWcspPoolMaxIdle());
        context.setPoolMinIdle(this.fieldEncryptionProperties.getWcspPoolMinIdle());
        context.setPoolMaxWaitMillis(this.fieldEncryptionProperties.getWcspPoolMaxWaitMillis());
        context.setVersion(this.fieldEncryptionProperties.getWcspVersion());
        context.setKeyId(this.fieldEncryptionProperties.getWcspKeyId());
        WcspCryptoServicePlatformPool pool = new WcspCryptoServicePlatformPool(context);
        EncryptUtils.wcspInitialize((WcspCryptoServicePlatformPool)pool);
        return pool;
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis-encryptor.rocksDB.enabled"}, havingValue="true")
    public RocksDBConfig rocksDBConfig() {
        log.info("\u521b\u5efa RocksDBConfig Bean");
        return new RocksDBConfig(this.fieldEncryptionProperties.getRocksDB().getDataDir());
    }

    @Generated
    public WcspConfig(ApiProperties apiProperties, FieldEncryptorProperties fieldEncryptionProperties) {
        this.apiProperties = apiProperties;
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }
}

