/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.task;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.extend.wcsp.dao.DataEncryptMapper;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocument3Mapper;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocumentMapper;
import cn.smarthse.extend.wcsp.esservice.SysDataEncryptDocument3Manager;
import cn.smarthse.extend.wcsp.esservice.SysDataEncryptDocumentManager;
import cn.smarthse.extend.wcsp.model.EncryptionConfig;
import cn.smarthse.extend.wcsp.provider.HZEsEncryptServiceProviderImpl;
import cn.smarthse.framework.json.utils.JsonUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataEncryptTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEncryptTask.class);
    private final HZEsEncryptServiceProviderImpl hZEsEncryptServiceProviderImpl;
    private final DataEncryptMapper dataEncryptMapper;
    private final SysDataEncryptDocumentManager sysDataEncryptDocumentManager;
    private final SysDataEncryptDocument3Manager sysDataEncryptDocument3Manager;
    private final SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper;
    private final SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper;

    @XxlJob(value="springEncryptUtils-encrypt")
    public String springEncryptUtilsEncrypt() {
        String s = XxlJobHelper.getJobParam();
        if (Objects.isNull(s)) {
            return null;
        }
        String rst = SpringEncryptUtils.encrypt((String)s);
        XxlJobHelper.log((String)"\u52a0\u5bc6\u7ed3\u679c: {}", (Object[])new Object[]{rst});
        return rst;
    }

    @XxlJob(value="springEncryptUtils-decrypt")
    public String springEncryptUtilsDecrypt() {
        String s = XxlJobHelper.getJobParam();
        if (StrUtil.isBlank((CharSequence)s)) {
            return null;
        }
        String rst = SpringEncryptUtils.decrypt((String)s);
        XxlJobHelper.log((String)"\u89e3\u5bc6\u7ed3\u679c: {}", (Object[])new Object[]{rst});
        return rst;
    }

    @XxlJob(value="createIndex3")
    public Boolean createIndex3() {
        return this.sysDataEncryptDocument3Mapper.createIndex();
    }

    @XxlJob(value="deleteIndex3")
    public Boolean deleteIndex3() {
        return this.sysDataEncryptDocument3Mapper.deleteIndex();
    }

    @XxlJob(value="migrateDataWithPagination3")
    public void migrateDataWithPagination3() {
        this.sysDataEncryptDocument3Manager.migrateDataWithPagination();
    }

    @XxlJob(value="esEncryptService-loadCache")
    public void esEncryptServiceLoadCache() {
        this.hZEsEncryptServiceProviderImpl.loadCache();
    }

    @XxlJob(value="esEncryptService-loadRocksDB")
    public void esEncryptServiceLoadRocksDB() {
        this.hZEsEncryptServiceProviderImpl.loadRocksDB();
    }

    @XxlJob(value="addCiphertext")
    public void addCiphertext() {
        Map paramMap = (Map)JsonUtils.parseObject((String)XxlJobHelper.getJobParam(), Map.class);
        this.hZEsEncryptServiceProviderImpl.addCiphertext((String)paramMap.get("plaintext"), (String)paramMap.get("ciphertext"));
    }

    @XxlJob(value="getCiphertext")
    public String getCiphertext() {
        String s = XxlJobHelper.getJobParam();
        if (Objects.isNull(s)) {
            return null;
        }
        String rst = this.hZEsEncryptServiceProviderImpl.getCiphertext(s);
        XxlJobHelper.log((String)"getCiphertext: {}", (Object[])new Object[]{rst});
        return rst;
    }

    @XxlJob(value="getPlaintext")
    public String getPlaintext() {
        String s = XxlJobHelper.getJobParam();
        if (Objects.isNull(s)) {
            return null;
        }
        String rst = this.hZEsEncryptServiceProviderImpl.getPlaintext(s);
        XxlJobHelper.log((String)"getPlaintext: {}", (Object[])new Object[]{rst});
        return rst;
    }

    @XxlJob(value="encryptJobHandler")
    public void encryptJobHandler() {
        try {
            Map paramMap = (Map)JsonUtils.parseObject((String)XxlJobHelper.getJobParam(), Map.class);
            this.sysDataEncryptDocumentManager.batchEncryptData((String)paramMap.get("databaseName"), (String)paramMap.get("tableName"), (String)paramMap.get("idColumn"), (String)paramMap.get("dataColumn"), (String)paramMap.get("idType"));
        }
        catch (Exception e) {
            log.error("\u5206\u7247\u5904\u7406\u5f02\u5e38", (Throwable)e);
            XxlJobHelper.log((String)"\u8c03\u7528 batchEncryptData \u5f02\u5e38: {}", (Object[])new Object[]{e.getMessage()});
        }
    }

    @XxlJob(value="encryptJobHandler-loadEncryptionConfigs")
    public void encryptJobHandlerLoadEncryptionConfigs() {
        List<EncryptionConfig> encryptionConfigs = this.dataEncryptMapper.selectAllEncryptionConfigs();
        log.info("\u52a0\u8f7d\u5230 {} \u4e2a\u52a0\u5bc6\u914d\u7f6e", (Object)encryptionConfigs.size());
        encryptionConfigs = encryptionConfigs.stream().sorted(Comparator.comparingLong(EncryptionConfig::getId)).collect(Collectors.toList());
        encryptionConfigs.forEach(config -> {
            log.info("\u5f00\u59cb\u5904\u7406\u914d\u7f6e[{}]", (Object)config.getId());
            XxlJobHelper.log((String)"\u5f00\u59cb\u5904\u7406\u914d\u7f6e[{}]", (Object[])new Object[]{config.getId()});
            if (Boolean.TRUE.equals(config.getEnabled())) {
                try {
                    this.sysDataEncryptDocumentManager.batchEncryptData(config.getDatabaseName(), config.getTableName(), config.getIdColumn(), config.getDataColumn(), config.getIdType());
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u914d\u7f6e[{}]\u52a0\u5bc6\u4efb\u52a1\u5931\u8d25", (Object)config.getId(), (Object)e);
                    XxlJobHelper.log((String)"\u6267\u884c\u914d\u7f6e[{}]\u52a0\u5bc6\u4efb\u52a1\u5931\u8d25: {}", (Object[])new Object[]{config.getId(), e.getMessage()});
                }
            } else {
                log.info("\u914d\u7f6e[{}]\u5df2\u7981\u7528\uff0c\u8df3\u8fc7", (Object)config.getId());
                XxlJobHelper.log((String)"\u914d\u7f6e[{}]\u5df2\u7981\u7528\uff0c\u8df3\u8fc7", (Object[])new Object[]{config.getId()});
            }
        });
        log.info("\u5904\u7406\u6240\u6709\u914d\u7f6e\u5b8c\u6210");
        XxlJobHelper.log((String)"\u5904\u7406\u6240\u6709\u914d\u7f6e\u5b8c\u6210", (Object[])new Object[0]);
    }

    @Generated
    public DataEncryptTask(HZEsEncryptServiceProviderImpl hZEsEncryptServiceProviderImpl, DataEncryptMapper dataEncryptMapper, SysDataEncryptDocumentManager sysDataEncryptDocumentManager, SysDataEncryptDocument3Manager sysDataEncryptDocument3Manager, SysDataEncryptDocumentMapper sysDataEncryptDocumentMapper, SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper) {
        this.hZEsEncryptServiceProviderImpl = hZEsEncryptServiceProviderImpl;
        this.dataEncryptMapper = dataEncryptMapper;
        this.sysDataEncryptDocumentManager = sysDataEncryptDocumentManager;
        this.sysDataEncryptDocument3Manager = sysDataEncryptDocument3Manager;
        this.sysDataEncryptDocumentMapper = sysDataEncryptDocumentMapper;
        this.sysDataEncryptDocument3Mapper = sysDataEncryptDocument3Mapper;
    }
}

