/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.wcsp.provider;

import cn.smarthse.encrypt.spring.properties.RocksDBConfig;
import cn.smarthse.encrypt.spring.service.EsEncryptService;
import cn.smarthse.extend.wcsp.document.SysDataEncryptDocument3;
import cn.smarthse.extend.wcsp.esmapper.SysDataEncryptDocument3Mapper;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.redis.utils.RedisUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.dromara.easyes.core.biz.SAPageInfo;
import org.dromara.easyes.core.conditions.select.LambdaEsQueryWrapper;
import org.dromara.easyes.core.kernel.EsWrappers;
import org.dromara.easyes.core.kernel.Wrapper;
import org.redisson.api.RLock;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class HZEsEncryptServiceProviderImpl
implements EsEncryptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HZEsEncryptServiceProviderImpl.class);
    private final SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper;
    private final RocksDBConfig rocksDBConfig;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final String PLAINTEXT_PREFIX = "plaintext:";
    private static final String CIPHERTEXT_PREFIX = "ciphertext:";
    private static final Cache<String, String> keyForPlaintextCache = Caffeine.newBuilder().maximumSize(2000000L).recordStats().build();
    private static final Cache<String, String> keyForCiphertextCache = Caffeine.newBuilder().maximumSize(2000000L).recordStats().build();

    @Scheduled(fixedRate=300000L)
    public void logCacheStats() {
        CacheStats keyForPlaintextCacheStats = keyForPlaintextCache.stats();
        CacheStats keyForCiphertextCacheStats = keyForCiphertextCache.stats();
        long keyForPlaintextCacheRequests = keyForPlaintextCacheStats.requestCount();
        long keyForCiphertextCacheRequests = keyForCiphertextCacheStats.requestCount();
        String plaintextHitRate = keyForPlaintextCacheRequests == 0L ? "N/A" : String.format("%.2f", keyForPlaintextCacheStats.hitRate() * 100.0);
        String ciphertextHitRate = keyForCiphertextCacheRequests == 0L ? "N/A" : String.format("%.2f", keyForCiphertextCacheStats.hitRate() * 100.0);
        long keyForPlaintextCacheSize = keyForPlaintextCache.estimatedSize();
        long keyForCiphertextCacheSize = keyForCiphertextCache.estimatedSize();
        log.info("Cache Statistics Report - keyForPlaintextCache: Size\uff1a{}, HitRate\uff1a{}%, Hits\uff1a{}, Misses\uff1a{}, Requests\uff1a{}, Evictions\uff1a{}", new Object[]{keyForPlaintextCacheSize, plaintextHitRate, keyForPlaintextCacheStats.hitCount(), keyForPlaintextCacheStats.missCount(), keyForPlaintextCacheRequests, keyForPlaintextCacheStats.evictionCount()});
        log.info("Cache Statistics Report - keyForCiphertextCache: Size\uff1a{}, HitRate\uff1a{}%, Hits\uff1a{}, Misses\uff1a{}, Requests\uff1a{}, Evictions\uff1a{}", new Object[]{keyForCiphertextCacheSize, ciphertextHitRate, keyForCiphertextCacheStats.hitCount(), keyForCiphertextCacheStats.missCount(), keyForCiphertextCacheRequests, keyForCiphertextCacheStats.evictionCount()});
    }

    public void loadCache() {
        int pageSize = 10000;
        int pageNum = 1;
        long totalLoaded = 0L;
        long totalAttempted = 0L;
        log.info("\u5f00\u59cb\u4eceElasticsearch\u52a0\u8f7d\u7f13\u5b58\u6570\u636e...");
        XxlJobHelper.log((String)"\u5f00\u59cb\u4eceElasticsearch\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\uff0c\u5206\u9875\u5927\u5c0f: {}", (Object[])new Object[]{pageSize});
        keyForPlaintextCache.invalidateAll();
        keyForCiphertextCache.invalidateAll();
        XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\uff0c\u6bcf\u9875{}\u6761", (Object[])new Object[]{pageNum, pageSize});
        LambdaEsQueryWrapper lambdaEsQueryWrapper = EsWrappers.lambdaQuery(SysDataEncryptDocument3.class);
        lambdaEsQueryWrapper.size(Integer.valueOf(pageSize));
        ((LambdaEsQueryWrapper)lambdaEsQueryWrapper.orderByDesc(SysDataEncryptDocument3::getPlaintext)).orderByDesc(SysDataEncryptDocument3::getId);
        List searchAfter = null;
        boolean hasMoreData = true;
        long totalSkippedRecords = 0L;
        while (hasMoreData) {
            SAPageInfo documents;
            try {
                documents = this.sysDataEncryptDocument3Mapper.searchAfterPage((Wrapper)lambdaEsQueryWrapper, searchAfter, pageSize);
                if (documents.getNextSearchAfter() != null) {
                    XxlJobHelper.log((String)"\u7b2c{}\u9875\u67e5\u8be2\u5b8c\u6210\uff0c\u83b7\u53d6{}\u6761\u8bb0\u5f55\uff0csearchAfter\u503c\u957f\u5ea6: {}", (Object[])new Object[]{pageNum, documents.getList() != null ? documents.getList().size() : 0, documents.getNextSearchAfter().size()});
                }
                searchAfter = documents.getNextSearchAfter();
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25", (Object)pageNum, (Object)e);
                XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25: {}", (Object[])new Object[]{pageNum, e.getMessage()});
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u9875\u7801: " + pageNum, e);
            }
            if (documents.getList() == null || documents.getList().isEmpty()) {
                XxlJobHelper.log((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7ed3\u675f\u7f13\u5b58\u52a0\u8f7d", (Object[])new Object[0]);
                break;
            }
            XxlJobHelper.log((String)"\u5904\u7406\u7b2c{}\u9875\u7684{}\u6761\u6570\u636e", (Object[])new Object[]{pageNum, documents.getList().size()});
            int pageLoaded = 0;
            int pageSkipped = 0;
            for (SysDataEncryptDocument3 record : documents.getList()) {
                String plaintext = record.getPlaintext();
                String ciphertext = record.getCiphertext();
                String id = record.getId();
                if (++totalAttempted % 10000L == 0L) {
                    XxlJobHelper.log((String)"\u5904\u7406\u8fdb\u5ea6: \u5df2\u5c1d\u8bd5{}\u6761\u8bb0\u5f55\uff0c\u5f53\u524dID: {}", (Object[])new Object[]{totalAttempted, id});
                }
                if (StringUtils.isBlank((CharSequence)plaintext) || StringUtils.isBlank((CharSequence)ciphertext)) {
                    ++pageSkipped;
                    ++totalSkippedRecords;
                    continue;
                }
                try {
                    keyForPlaintextCache.put((Object)plaintext, (Object)ciphertext);
                    keyForCiphertextCache.put((Object)ciphertext, (Object)plaintext);
                    ++pageLoaded;
                    ++totalLoaded;
                }
                catch (Exception e) {
                    ++pageSkipped;
                    ++totalSkippedRecords;
                    log.error("\u7f13\u5b58\u6570\u636e\u5931\u8d25 - ID: {}, plaintext: {}", new Object[]{id, plaintext, e});
                }
            }
            XxlJobHelper.log((String)"\u7b2c{}\u9875\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f{}\u6761\uff0c\u8df3\u8fc7{}\u6761\uff0c\u7d2f\u8ba1\u52a0\u8f7d{}\u6761", (Object[])new Object[]{pageNum, pageLoaded, pageSkipped, totalLoaded});
            if (documents.getList().size() < pageSize) {
                XxlJobHelper.log((String)"\u5f53\u524d\u9875\u6570\u636e\u5c11\u4e8e\u9875\u9762\u5927\u5c0f({})\uff0c\u5b9e\u9645\u83b7\u53d6{}\u6761\uff0c\u7ed3\u675f\u7f13\u5b58\u52a0\u8f7d", (Object[])new Object[]{pageSize, documents.getList().size()});
                hasMoreData = false;
            } else {
                hasMoreData = true;
            }
            ++pageNum;
        }
        log.info("\u7f13\u5b58\u52a0\u8f7d\u5b8c\u6210\uff0c\u603b\u5171\u5c1d\u8bd5\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u5b9e\u9645\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u8df3\u8fc7{}\u6761\u8bb0\u5f55", new Object[]{totalAttempted, totalLoaded, totalSkippedRecords});
        XxlJobHelper.log((String)"\u7f13\u5b58\u52a0\u8f7d\u5b8c\u6210\uff0c\u603b\u5171\u5c1d\u8bd5\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u5b9e\u9645\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u8df3\u8fc7{}\u6761\u8bb0\u5f55", (Object[])new Object[]{totalAttempted, totalLoaded, totalSkippedRecords});
        try {
            long dbCount = this.sysDataEncryptDocument3Mapper.selectCount((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class));
            XxlJobHelper.log((String)"\u6570\u636e\u5e93\u603b\u8bb0\u5f55\u6570: {}, \u7f13\u5b58\u52a0\u8f7d\u8bb0\u5f55\u6570: {}, \u5dee\u5f02: {}", (Object[])new Object[]{dbCount, totalLoaded, dbCount - totalLoaded});
        }
        catch (Exception e) {
            XxlJobHelper.log((String)"\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u5e93\u603b\u8bb0\u5f55\u6570: {}", (Object[])new Object[]{e.getMessage()});
        }
        log.info("\u5f53\u524d\u7f13\u5b58\u5927\u5c0f - \u660e\u6587\u7f13\u5b58: {}\uff0c\u5bc6\u6587\u7f13\u5b58: {}", (Object)keyForPlaintextCache.estimatedSize(), (Object)keyForCiphertextCache.estimatedSize());
        XxlJobHelper.log((String)"\u5f53\u524d\u7f13\u5b58\u5927\u5c0f - \u660e\u6587\u7f13\u5b58: {}\uff0c\u5bc6\u6587\u7f13\u5b58: {}", (Object[])new Object[]{keyForPlaintextCache.estimatedSize(), keyForCiphertextCache.estimatedSize()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRocksDB() {
        int pageSize = 10000;
        int pageNum = 1;
        long totalLoaded = 0L;
        long totalAttempted = 0L;
        log.info("\u5f00\u59cb\u4eceElasticsearch\u52a0\u8f7d\u6570\u636e\u5230RocksDB...");
        XxlJobHelper.log((String)"\u5f00\u59cb\u4eceElasticsearch\u52a0\u8f7d\u6570\u636e\u5230RocksDB\uff0c\u5206\u9875\u5927\u5c0f: {}", (Object[])new Object[]{pageSize});
        XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\uff0c\u6bcf\u9875{}\u6761", (Object[])new Object[]{pageNum, pageSize});
        LambdaEsQueryWrapper lambdaEsQueryWrapper = EsWrappers.lambdaQuery(SysDataEncryptDocument3.class);
        lambdaEsQueryWrapper.size(Integer.valueOf(pageSize));
        ((LambdaEsQueryWrapper)lambdaEsQueryWrapper.orderByDesc(SysDataEncryptDocument3::getPlaintext)).orderByDesc(SysDataEncryptDocument3::getId);
        List searchAfter = null;
        boolean hasMoreData = true;
        long totalSkippedRecords = 0L;
        while (hasMoreData) {
            SAPageInfo documents;
            try {
                documents = this.sysDataEncryptDocument3Mapper.searchAfterPage((Wrapper)lambdaEsQueryWrapper, searchAfter, pageSize);
                if (documents.getNextSearchAfter() != null) {
                    XxlJobHelper.log((String)"\u7b2c{}\u9875\u67e5\u8be2\u5b8c\u6210\uff0c\u83b7\u53d6{}\u6761\u8bb0\u5f55\uff0csearchAfter\u503c\u957f\u5ea6: {}", (Object[])new Object[]{pageNum, documents.getList() != null ? documents.getList().size() : 0, documents.getNextSearchAfter().size()});
                }
                searchAfter = documents.getNextSearchAfter();
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25", (Object)pageNum, (Object)e);
                XxlJobHelper.log((String)"\u67e5\u8be2\u7b2c{}\u9875\u6570\u636e\u5931\u8d25: {}", (Object[])new Object[]{pageNum, e.getMessage()});
                throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u9875\u7801: " + pageNum, e);
            }
            if (documents.getList() == null || documents.getList().isEmpty()) {
                XxlJobHelper.log((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u7ed3\u675fRocksDB\u52a0\u8f7d", (Object[])new Object[0]);
                break;
            }
            XxlJobHelper.log((String)"\u5904\u7406\u7b2c{}\u9875\u7684{}\u6761\u6570\u636e", (Object[])new Object[]{pageNum, documents.getList().size()});
            int pageLoaded = 0;
            int pageSkipped = 0;
            try {
                this.readWriteLock.writeLock().lock();
                for (SysDataEncryptDocument3 record : documents.getList()) {
                    String plaintext = record.getPlaintext();
                    String ciphertext = record.getCiphertext();
                    String id = record.getId();
                    if (++totalAttempted % 10000L == 0L) {
                        XxlJobHelper.log((String)"\u5904\u7406\u8fdb\u5ea6: \u5df2\u5c1d\u8bd5{}\u6761\u8bb0\u5f55\uff0c\u5f53\u524dID: {}", (Object[])new Object[]{totalAttempted, id});
                    }
                    if (StringUtils.isBlank((CharSequence)plaintext) || StringUtils.isBlank((CharSequence)ciphertext)) {
                        ++pageSkipped;
                        ++totalSkippedRecords;
                        continue;
                    }
                    try {
                        String plaintextKey = PLAINTEXT_PREFIX + plaintext;
                        this.rocksDBConfig.getRocksDB().put(RocksDBConfig.stringToBytes((String)plaintextKey), RocksDBConfig.stringToBytes((String)ciphertext));
                        String ciphertextKey = CIPHERTEXT_PREFIX + ciphertext;
                        this.rocksDBConfig.getRocksDB().put(RocksDBConfig.stringToBytes((String)ciphertextKey), RocksDBConfig.stringToBytes((String)plaintext));
                        ++pageLoaded;
                        ++totalLoaded;
                    }
                    catch (RocksDBException e) {
                        ++pageSkipped;
                        ++totalSkippedRecords;
                        log.error("\u52a0\u8f7d\u6570\u636e\u5230RocksDB\u5931\u8d25 - ID: {}, plaintext: {}", new Object[]{id, plaintext, e});
                    }
                }
                XxlJobHelper.log((String)"\u7b2c{}\u9875\u5904\u7406\u5b8c\u6210\uff0c\u6210\u529f{}\u6761\uff0c\u8df3\u8fc7{}\u6761\uff0c\u7d2f\u8ba1\u52a0\u8f7d{}\u6761", (Object[])new Object[]{pageNum, pageLoaded, pageSkipped, totalLoaded});
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            if (documents.getList().size() < pageSize) {
                XxlJobHelper.log((String)"\u5f53\u524d\u9875\u6570\u636e\u5c11\u4e8e\u9875\u9762\u5927\u5c0f({})\uff0c\u5b9e\u9645\u83b7\u53d6{}\u6761\uff0c\u7ed3\u675fRocksDB\u52a0\u8f7d", (Object[])new Object[]{pageSize, documents.getList().size()});
                hasMoreData = false;
            } else {
                hasMoreData = true;
            }
            ++pageNum;
        }
        log.info("RocksDB\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u603b\u5171\u5c1d\u8bd5\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u5b9e\u9645\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u8df3\u8fc7{}\u6761\u8bb0\u5f55", new Object[]{totalAttempted, totalLoaded, totalSkippedRecords});
        XxlJobHelper.log((String)"RocksDB\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u603b\u5171\u5c1d\u8bd5\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u5b9e\u9645\u52a0\u8f7d{}\u6761\u8bb0\u5f55\uff0c\u8df3\u8fc7{}\u6761\u8bb0\u5f55", (Object[])new Object[]{totalAttempted, totalLoaded, totalSkippedRecords});
        try {
            long dbCount = this.sysDataEncryptDocument3Mapper.selectCount((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class));
            XxlJobHelper.log((String)"\u6570\u636e\u5e93\u603b\u8bb0\u5f55\u6570: {}, RocksDB\u52a0\u8f7d\u8bb0\u5f55\u6570: {}, \u5dee\u5f02: {}", (Object[])new Object[]{dbCount, totalLoaded, dbCount - totalLoaded});
        }
        catch (Exception e) {
            XxlJobHelper.log((String)"\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u5e93\u603b\u8bb0\u5f55\u6570: {}", (Object[])new Object[]{e.getMessage()});
        }
        log.info("RocksDB\u6570\u636e\u52a0\u8f7d\u5b8c\u6210");
        XxlJobHelper.log((String)"RocksDB\u6570\u636e\u52a0\u8f7d\u5b8c\u6210", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCiphertext(String plaintext, String ciphertext) {
        block17: {
            if (StringUtils.isBlank((CharSequence)plaintext) || StringUtils.isBlank((CharSequence)ciphertext)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("addCiphertext plaintext: {} ciphertext: {}", (Object)plaintext, (Object)ciphertext);
            }
            RLock lock = RedisUtils.getClient().getLock("addCiphertext:" + plaintext);
            try {
                if (lock.tryLock(3L, TimeUnit.SECONDS)) {
                    try {
                        SysDataEncryptDocument3 existingDocument;
                        try {
                            existingDocument = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectOne((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getPlaintext, (Object)plaintext));
                        }
                        catch (Exception e) {
                            log.warn("\u67e5\u8be2\u73b0\u6709\u660e\u6587\u548c\u5bc6\u6587\u8bb0\u5f55\u5931\u8d25\uff0c\u5c06\u53ea\u53d6\u5176\u4e2d\u4e00\u6761\u8bb0\u5f55: plaintext\uff1a{},ciphertext\uff1a{}. error\uff1a{}", new Object[]{plaintext, ciphertext, e.getMessage()});
                            existingDocument = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectList((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getPlaintext, (Object)plaintext)).get(0);
                        }
                        if (existingDocument != null) {
                            existingDocument.setCiphertext(ciphertext);
                            this.sysDataEncryptDocument3Mapper.updateById(existingDocument);
                            if (log.isDebugEnabled()) {
                                log.debug("ES \u66f4\u65b0\u73b0\u6709\u7684\u52a0\u5bc6\u8bb0\u5f55: plaintext {} ciphertext {}", (Object)plaintext, (Object)ciphertext);
                            }
                        } else {
                            SysDataEncryptDocument3 document = new SysDataEncryptDocument3();
                            document.setPlaintext(plaintext);
                            document.setCiphertext(ciphertext);
                            this.sysDataEncryptDocument3Mapper.insert(document);
                            if (log.isDebugEnabled()) {
                                log.debug("ES \u63d2\u5165\u65b0\u7684\u52a0\u5bc6\u8bb0\u5f55: plaintext {} ciphertext {}", (Object)plaintext, (Object)ciphertext);
                            }
                        }
                        keyForPlaintextCache.put((Object)plaintext, (Object)ciphertext);
                        keyForCiphertextCache.put((Object)ciphertext, (Object)plaintext);
                        break block17;
                    }
                    catch (Exception e) {
                        log.error("addCiphertext \u5931\u8d25\uff0cplaintext: {}, ciphertext: {}", new Object[]{plaintext, ciphertext, e});
                        break block17;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("addCiphertext \u9501\u88ab\u5176\u4ed6\u7ebf\u7a0b\u5360\u7528\uff0cplaintext: {}, ciphertext: {}", (Object)plaintext, (Object)ciphertext);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getCiphertext(String plaintext) {
        SysDataEncryptDocument3 document;
        String ciphertext;
        if (StringUtils.isBlank((CharSequence)plaintext)) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getCiphertext plaintext: {}", (Object)plaintext);
        }
        if ((ciphertext = (String)keyForPlaintextCache.getIfPresent((Object)plaintext)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("getCiphertext \u672c\u5730\u7f13\u5b58\u547d\u4e2d ciphertext: {} plaintext: {}", (Object)ciphertext, (Object)plaintext);
            }
            return ciphertext;
        }
        try {
            document = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectOne((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getPlaintext, (Object)plaintext));
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u73b0\u6709\u5bc6\u6587\u8bb0\u5f55\u5931\u8d25\uff0c\u5c06\u53ea\u53d6\u5176\u4e2d\u4e00\u6761\u8bb0\u5f55: plaintext\uff1a{}, error\uff1a{}", (Object)plaintext, (Object)e.getMessage());
            document = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectList((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getPlaintext, (Object)plaintext)).get(0);
        }
        String string = ciphertext = document == null ? null : document.getCiphertext();
        if (ciphertext != null) {
            if (log.isDebugEnabled()) {
                log.debug("getCiphertext es\u547d\u4e2d ciphertext: {} plaintext: {}", (Object)ciphertext, (Object)plaintext);
            }
            keyForPlaintextCache.put((Object)plaintext, (Object)ciphertext);
        }
        return ciphertext;
    }

    public String getPlaintext(String ciphertext) {
        SysDataEncryptDocument3 document;
        String plaintext;
        if (StringUtils.isBlank((CharSequence)ciphertext)) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("getPlaintext ciphertext: {}", (Object)ciphertext);
        }
        if ((plaintext = (String)keyForCiphertextCache.getIfPresent((Object)ciphertext)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("getPlaintext \u672c\u5730\u7f13\u5b58\u547d\u4e2d ciphertext: {} plaintext: {}", (Object)ciphertext, (Object)plaintext);
            }
            return plaintext;
        }
        try {
            document = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectOne((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getCiphertext, (Object)ciphertext));
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u73b0\u6709\u660e\u6587\u8bb0\u5f55\u5931\u8d25\uff0c\u5c06\u53ea\u53d6\u5176\u4e2d\u4e00\u6761\u8bb0\u5f55: ciphertext\uff1a{}, error\uff1a{}", (Object)ciphertext, (Object)e.getMessage());
            document = (SysDataEncryptDocument3)this.sysDataEncryptDocument3Mapper.selectList((Wrapper)EsWrappers.lambdaQuery(SysDataEncryptDocument3.class).eq(SysDataEncryptDocument3::getCiphertext, (Object)ciphertext)).get(0);
        }
        String string = plaintext = document == null ? null : document.getPlaintext();
        if (plaintext != null) {
            if (log.isDebugEnabled()) {
                log.debug("getPlaintext es\u547d\u4e2d ciphertext: {} plaintext: {}", (Object)ciphertext, (Object)plaintext);
            }
            keyForCiphertextCache.put((Object)ciphertext, (Object)plaintext);
        }
        return plaintext;
    }

    @Generated
    public HZEsEncryptServiceProviderImpl(SysDataEncryptDocument3Mapper sysDataEncryptDocument3Mapper, RocksDBConfig rocksDBConfig) {
        this.sysDataEncryptDocument3Mapper = sysDataEncryptDocument3Mapper;
        this.rocksDBConfig = rocksDBConfig;
    }
}

