/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.monitor.notifier;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.notify.AbstractEventNotifier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class CustomNotifier
extends AbstractEventNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomNotifier.class);

    protected CustomNotifier(InstanceRepository repository) {
        super(repository);
    }

    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        return Mono.fromRunnable(() -> {
            if (event instanceof InstanceStatusChangedEvent) {
                String registName = instance.getRegistration().getName();
                String instanceId = event.getInstance().getValue();
                String status = ((InstanceStatusChangedEvent)event).getStatusInfo().getStatus();
                String serviceUrl = instance.getRegistration().getServiceUrl();
                String statusName = switch (status) {
                    case "UP" -> "\u670d\u52a1\u4e0a\u7ebf";
                    case "OFFLINE" -> "\u670d\u52a1\u79bb\u7ebf";
                    case "RESTRICTED" -> "\u670d\u52a1\u53d7\u9650";
                    case "OUT_OF_SERVICE" -> "\u505c\u6b62\u670d\u52a1\u72b6\u6001";
                    case "DOWN" -> "\u670d\u52a1\u4e0b\u7ebf";
                    case "UNKNOWN" -> "\u670d\u52a1\u672a\u77e5\u5f02\u5e38";
                    default -> "\u672a\u77e5\u72b6\u6001";
                };
                log.info("Instance Status Change: \u72b6\u6001\u540d\u79f0\u3010{}\u3011, \u6ce8\u518c\u540d\u79f0\u3010{}\u3011, \u5b9e\u4f8bID\u3010{}\u3011, \u72b6\u6001\u3010{}\u3011, \u670d\u52a1URL\u3010{}\u3011", new Object[]{statusName, registName, instanceId, status, serviceUrl});
            }
        });
    }
}

