/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.shardingsphere.config;

import cn.smarthse.encrypt.context.WcspEncryptContext;
import cn.smarthse.encrypt.pool.WcspCryptoServicePlatformPool;
import cn.smarthse.encrypt.spring.properties.FieldEncryptorProperties;
import cn.smarthse.encrypt.utils.EncryptUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={FieldEncryptorProperties.class})
public class FieldEncryptorAutoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldEncryptorAutoConfig.class);
    private final FieldEncryptorProperties fieldEncryptionProperties;

    @Bean(destroyMethod="close")
    @ConditionalOnProperty(value={"mybatis-encryptor.algorithm"}, havingValue="WCSP_LIGHT_DATA_SERVICE")
    public WcspCryptoServicePlatformPool wcspCryptoServicePlatformPool() {
        log.info("\u521d\u59cb\u5316 WcspEncryptUtils \u914d\u7f6e");
        WcspEncryptContext context = new WcspEncryptContext();
        context.setUrl(this.fieldEncryptionProperties.getWcspUrl());
        context.setTenantId(this.fieldEncryptionProperties.getWcspTenantId());
        context.setAppId(this.fieldEncryptionProperties.getWcspAppId());
        context.setSecret(this.fieldEncryptionProperties.getWcspSecret());
        context.setWorkDir(this.fieldEncryptionProperties.getWcspWorkDir());
        context.setPoolMaxTotal(this.fieldEncryptionProperties.getWcspPoolMaxTotal());
        context.setPoolMaxIdle(this.fieldEncryptionProperties.getWcspPoolMaxIdle());
        context.setPoolMinIdle(this.fieldEncryptionProperties.getWcspPoolMinIdle());
        context.setPoolMaxWaitMillis(this.fieldEncryptionProperties.getWcspPoolMaxWaitMillis());
        context.setVersion(this.fieldEncryptionProperties.getWcspVersion());
        context.setKeyId(this.fieldEncryptionProperties.getWcspKeyId());
        WcspCryptoServicePlatformPool pool = new WcspCryptoServicePlatformPool(context);
        EncryptUtils.wcspInitialize((WcspCryptoServicePlatformPool)pool);
        return pool;
    }

    @Generated
    public FieldEncryptorAutoConfig(FieldEncryptorProperties fieldEncryptionProperties) {
        this.fieldEncryptionProperties = fieldEncryptionProperties;
    }
}

