/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.prometheus.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ActuatorAuthFilter
implements Filter {
    private final int managementPort;
    private final String username;
    private final String password;

    public ActuatorAuthFilter(int managementPort, String username, String password) {
        this.managementPort = managementPort;
        this.username = username;
        this.password = password;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String authHeader;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getLocalPort() == this.managementPort && !this.isValidAuthHeader(authHeader = httpRequest.getHeader("Authorization"))) {
            this.sendUnauthorized(httpResponse);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isValidAuthHeader(String authHeader) {
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            return false;
        }
        String base64Credentials = authHeader.substring("Basic ".length());
        String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
        String[] values = credentials.split(":", 2);
        return values.length == 2 && this.username.equals(values[0]) && this.password.equals(values[1]);
    }

    private void sendUnauthorized(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "Basic realm=\"Actuator Management Port\"");
        response.getWriter().write("Authentication required for management port");
    }
}

