/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.mybatisPlus.handler;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=0x7FFFFFFE)
@RestControllerAdvice
public class MybatisExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MybatisExceptionHandler.class);

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResponseData<Object> handleDuplicateKeyException(DuplicateKeyException e, HttpServletRequest request) {
        if (Objects.nonNull(request)) {
            log.error("[MyBatis] [\u4e3b\u952e\u51b2\u7a81] [failure] [error] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        } else {
            log.error("[MyBatis] [\u4e3b\u952e\u51b2\u7a81] [failure] [error] [unknown] exceptionClass={} message={}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        }
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    public ResponseData<Object> handleCannotFindDataSourceException(MyBatisSystemException e, HttpServletRequest request) {
        if (Objects.nonNull(request)) {
            log.error("[MyBatis] [\u7cfb\u7edf\u5f02\u5e38] [failure] [error] [web] ip={} userAgent={} requestUri={} exceptionClass={} message={}", new Object[]{ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]), ServletUtils.getUserAgent((HttpServletRequest)request), ServletUtils.getRequestUri((HttpServletRequest)request), e.getClass().getSimpleName(), e.getMessage(), e});
        } else {
            log.error("[MyBatis] [\u7cfb\u7edf\u5f02\u5e38] [failure] [error] [unknown] exceptionClass={} message={}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        }
        if (Objects.isNull(request)) {
            return null;
        }
        ResponseData r = new ResponseData();
        r.setState(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue());
        r.setMessage(ResponseStateEnum.INTERNAL_SERVER_ERROR.getName());
        return r;
    }
}

