/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.extend.monitor.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actuator/prometheus"})
public class PrometheusController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusController.class);
    private static final String MANAGEMENT_SERVER_PORT = "management.server.port";
    private static final String MANAGEMENT_SERVER_BASEPATH = "management.server.basePath";
    @Value(value="${dubbo.registry.address}")
    private String registryAddress;
    private ServiceDiscovery serviceDiscovery;

    @PostConstruct
    public void init() {
        try {
            URL registryURL = URL.valueOf((String)this.registryAddress);
            ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension((URL)registryURL);
            this.serviceDiscovery = factory.getServiceDiscovery(registryURL);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316 Dubbo ServiceDiscovery \u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"/sd"})
    public List<Map<String, Object>> sd() {
        Set services = this.serviceDiscovery.getServices();
        if (CollUtil.isEmpty((Collection)services)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String service : services) {
            List instances = this.serviceDiscovery.getInstances(service);
            if (CollUtil.isEmpty((Collection)instances)) continue;
            List targets = instances.stream().map(i -> i.getHost() + ":" + (String)i.getMetadata().get(MANAGEMENT_SERVER_PORT)).collect(Collectors.toList());
            HashMap<String, String> labels = new HashMap<String, String>(2);
            labels.put("__meta_datacenter", "hangzhou");
            labels.put("__meta_prometheus_job", service);
            String basePath = (String)((ServiceInstance)instances.get(0)).getMetadata().get(MANAGEMENT_SERVER_BASEPATH);
            if (StrUtil.isNotBlank((CharSequence)basePath)) {
                labels.put("__meta_http_sd_base_path", basePath);
            }
            HashMap<String, Object> group = new HashMap<String, Object>(2);
            group.put("targets", targets);
            group.put("labels", labels);
            list.add(group);
        }
        return list;
    }

    @PostMapping(value={"/alerts"})
    public ResponseEntity<Void> alerts(@RequestBody String message) {
        log.info("[prometheus] alert =>" + message);
        return ResponseEntity.ok().build();
    }

    @Generated
    public PrometheusController() {
    }
}

