/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.handler;

import cn.hutool.core.collection.CollUtil;
import cn.idev.excel.annotation.ExcelProperty;
import cn.idev.excel.metadata.data.DataFormatData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.util.StyleUtil;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.handler.SheetWriteHandler;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.style.WriteCellStyle;
import cn.idev.excel.write.metadata.style.WriteFont;
import cn.smarthse.framework.excel.annotation.ExcelNotation;
import cn.smarthse.framework.excel.annotation.ExcelRequired;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class DataWriteHandler
implements SheetWriteHandler,
CellWriteHandler {
    private final Map<String, String> notationMap;
    private final Map<String, Short> headColumnMap;

    public DataWriteHandler(Class<?> clazz) {
        this.notationMap = DataWriteHandler.getNotationMap(clazz);
        this.headColumnMap = DataWriteHandler.getRequiredMap(clazz);
    }

    public void afterCellDispose(CellWriteHandlerContext context) {
        if (CollUtil.isEmpty(this.notationMap) && CollUtil.isEmpty(this.headColumnMap)) {
            return;
        }
        WriteCellData cellData = context.getFirstCellData();
        WriteCellStyle writeCellStyle = cellData.getOrCreateStyle();
        if (context.getHead().booleanValue()) {
            DataFormatData dataFormatData = new DataFormatData();
            dataFormatData.setIndex(Short.valueOf((short)49));
            writeCellStyle.setDataFormatData(dataFormatData);
            Cell cell = context.getCell();
            WriteSheetHolder writeSheetHolder = context.getWriteSheetHolder();
            Sheet sheet = writeSheetHolder.getSheet();
            Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
            Drawing drawing = sheet.createDrawingPatriarch();
            WriteFont headWriteFont = new WriteFont();
            headWriteFont.setBold(Boolean.valueOf(true));
            if (CollUtil.isNotEmpty(this.headColumnMap) && this.headColumnMap.containsKey(cell.getStringCellValue())) {
                headWriteFont.setColor(this.headColumnMap.get(cell.getStringCellValue()));
            }
            writeCellStyle.setWriteFont(headWriteFont);
            CellStyle cellStyle = StyleUtil.buildCellStyle((Workbook)workbook, null, (WriteCellStyle)writeCellStyle);
            cell.setCellStyle(cellStyle);
            if (CollUtil.isNotEmpty(this.notationMap) && this.notationMap.containsKey(cell.getStringCellValue())) {
                String notationContext = this.notationMap.get(cell.getStringCellValue());
                Comment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), 0, 5, 5));
                comment.setString((RichTextString)new XSSFRichTextString(notationContext));
                cell.setCellComment(comment);
            }
        }
    }

    private static Map<String, Short> getRequiredMap(Class<?> clazz) {
        Field[] fields;
        HashMap<String, Short> requiredMap = new HashMap<String, Short>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelRequired.class)) continue;
            ExcelRequired excelRequired = field.getAnnotation(ExcelRequired.class);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            requiredMap.put(excelProperty.value()[0], excelRequired.fontColor().getIndex());
        }
        return requiredMap;
    }

    private static Map<String, String> getNotationMap(Class<?> clazz) {
        Field[] fields;
        HashMap<String, String> notationMap = new HashMap<String, String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ExcelNotation.class)) continue;
            ExcelNotation excelNotation = field.getAnnotation(ExcelNotation.class);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            notationMap.put(excelProperty.value()[0], excelNotation.value());
        }
        return notationMap;
    }
}

