/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.convert;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.excel.annotation.ExcelDictFormat;
import cn.smarthse.framework.excel.service.DictService;
import cn.smarthse.framework.excel.utils.ExcelUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDictConvert
implements Converter<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelDictConvert.class);

    public Class<Object> supportJavaTypeKey() {
        return Object.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public Object convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        ExcelDictFormat anno = this.getAnnotation(contentProperty.getField());
        String type = anno.dictType();
        String label = cellData.getStringValue();
        String value = StringUtils.isBlank((CharSequence)type) ? ExcelUtil.reverseByExp(label, anno.readConverterExp(), anno.separator()) : ((DictService)SpringUtils.getBean(DictService.class)).getDictValue(type, label, anno.separator());
        return Convert.convert(contentProperty.getField().getType(), (Object)value);
    }

    public WriteCellData<String> convertToExcelData(Object object, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (ObjectUtil.isNull((Object)object)) {
            return new WriteCellData("");
        }
        ExcelDictFormat anno = this.getAnnotation(contentProperty.getField());
        String type = anno.dictType();
        String value = Convert.toStr((Object)object);
        String label = StringUtils.isBlank((CharSequence)type) ? ExcelUtil.convertByExp(value, anno.readConverterExp(), anno.separator()) : ((DictService)SpringUtils.getBean(DictService.class)).getDictLabel(type, value, anno.separator());
        return new WriteCellData(label);
    }

    private ExcelDictFormat getAnnotation(Field field) {
        return (ExcelDictFormat)AnnotationUtil.getAnnotation((AnnotatedElement)field, ExcelDictFormat.class);
    }
}

