/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.file.FileUtils;
import cn.smarthse.framework.excel.convert.ExcelBigNumberConvert;
import cn.smarthse.framework.excel.core.CellMergeStrategy;
import cn.smarthse.framework.excel.core.DefaultExcelListener;
import cn.smarthse.framework.excel.core.DropDownOptions;
import cn.smarthse.framework.excel.core.ExcelDownHandler;
import cn.smarthse.framework.excel.core.ExcelListener;
import cn.smarthse.framework.excel.core.ExcelResult;
import cn.smarthse.framework.excel.handler.DataWriteHandler;
import cn.smarthse.framework.excel.utils.ExcelWriterWrapper;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public class ExcelUtil {
    public static String appendErrorReason(String currentErrorReason, String newError) {
        if (StrUtil.isNotBlank((CharSequence)currentErrorReason)) {
            return currentErrorReason + "\uff1b" + newError;
        }
        return newError;
    }

    public static String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    public static <T> List<T> importExcel(InputStream is, Class<T> clazz) {
        return ((ExcelReaderBuilder)EasyExcel.read((InputStream)is).head(clazz)).autoCloseStream(Boolean.valueOf(false)).sheet().doReadSync();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Class<T> clazz, boolean isValidate) {
        DefaultExcelListener listener = new DefaultExcelListener(isValidate);
        EasyExcel.read((InputStream)is, clazz, listener).sheet().doRead();
        return listener.getExcelResult();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Class<T> clazz, ExcelListener<T> listener) {
        EasyExcel.read((InputStream)is, clazz, listener).sheet().doRead();
        return listener.getExcelResult();
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Class<T> clazz, ExcelListener<T> listener, int headRowNumber) {
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)is, clazz, listener).sheet().headRowNumber(Integer.valueOf(headRowNumber))).doRead();
        return listener.getExcelResult();
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, HttpServletResponse response) {
        try {
            ExcelUtil.resetResponse(sheetName, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportExcel(list, sheetName, clazz, false, (OutputStream)os, null);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, HttpServletResponse response, List<DropDownOptions> options) {
        try {
            ExcelUtil.resetResponse(sheetName, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportExcel(list, sheetName, clazz, false, (OutputStream)os, options);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, boolean merge, HttpServletResponse response) {
        try {
            ExcelUtil.resetResponse(sheetName, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportExcel(list, sheetName, clazz, merge, (OutputStream)os, null);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, boolean merge, HttpServletResponse response, List<DropDownOptions> options) {
        try {
            ExcelUtil.resetResponse(sheetName, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportExcel(list, sheetName, clazz, merge, (OutputStream)os, options);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, OutputStream os) {
        ExcelUtil.exportExcel(list, sheetName, clazz, false, os, null);
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, OutputStream os, List<DropDownOptions> options) {
        ExcelUtil.exportExcel(list, sheetName, clazz, false, os, options);
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<T> clazz, boolean merge, OutputStream os, List<DropDownOptions> options) {
        ExcelWriterSheetBuilder builder = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os, clazz).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).registerWriteHandler((WriteHandler)new DataWriteHandler(clazz))).sheet(sheetName);
        if (merge) {
            builder.registerWriteHandler((WriteHandler)new CellMergeStrategy(list, true));
        }
        builder.registerWriteHandler((WriteHandler)new ExcelDownHandler(options));
        builder.doWrite(list);
    }

    public static <T> void exportExcel(Class<T> headType, OutputStream os, List<DropDownOptions> options, Consumer<ExcelWriterWrapper<T>> consumer) {
        try (ExcelWriter writer = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os, headType).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).registerWriteHandler((WriteHandler)new DataWriteHandler(headType))).registerWriteHandler((WriteHandler)new ExcelDownHandler(options))).build();){
            consumer.accept(ExcelWriterWrapper.of(writer));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void exportExcel(Class<T> headType, OutputStream os, Consumer<ExcelWriterWrapper<T>> consumer) {
        ExcelUtil.exportExcel(headType, os, null, consumer);
    }

    public static <T> void exportTemplate(List<T> data, String filename, String templatePath, HttpServletResponse response) {
        try {
            if (CollUtil.isEmpty(data)) {
                throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
            }
            ExcelUtil.resetResponse(filename, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportTemplate(data, templatePath, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static <T> void exportTemplate(List<T> data, String templatePath, OutputStream os) {
        ClassPathResource templateResource = new ClassPathResource(templatePath);
        ExcelWriter excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).withTemplate(templateResource.getStream()).autoCloseStream(Boolean.valueOf(false)).registerConverter((Converter)new ExcelBigNumberConvert())).registerWriteHandler((WriteHandler)new DataWriteHandler(data.get(0).getClass()))).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        for (T d : data) {
            excelWriter.fill(d, fillConfig, writeSheet);
        }
        excelWriter.finish();
    }

    public static void exportTemplateMultiList(Map<String, Object> data, String filename, String templatePath, HttpServletResponse response) {
        try {
            if (CollUtil.isEmpty(data)) {
                throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
            }
            ExcelUtil.resetResponse(filename, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportTemplateMultiList(data, templatePath, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static void exportTemplateMultiSheet(List<Map<String, Object>> data, String filename, String templatePath, HttpServletResponse response) {
        try {
            if (CollUtil.isEmpty(data)) {
                throw new IllegalArgumentException("\u6570\u636e\u4e3a\u7a7a");
            }
            ExcelUtil.resetResponse(filename, response);
            ServletOutputStream os = response.getOutputStream();
            ExcelUtil.exportTemplateMultiSheet(data, templatePath, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
    }

    public static void exportTemplateMultiList(Map<String, Object> data, String templatePath, OutputStream os) {
        ClassPathResource templateResource = new ClassPathResource(templatePath);
        ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).withTemplate(templateResource.getStream()).autoCloseStream(Boolean.valueOf(false)).registerConverter((Converter)new ExcelBigNumberConvert())).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        for (Map.Entry<String, Object> map : data.entrySet()) {
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            if (map.getValue() instanceof Collection) {
                excelWriter.fill((Object)new FillWrapper(map.getKey(), (Collection)map.getValue()), fillConfig, writeSheet);
                continue;
            }
            excelWriter.fill(map.getValue(), fillConfig, writeSheet);
        }
        excelWriter.finish();
    }

    public static void exportTemplateMultiSheet(List<Map<String, Object>> data, String templatePath, OutputStream os) {
        ClassPathResource templateResource = new ClassPathResource(templatePath);
        ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).withTemplate(templateResource.getStream()).autoCloseStream(Boolean.valueOf(false)).registerConverter((Converter)new ExcelBigNumberConvert())).build();
        for (int i = 0; i < data.size(); ++i) {
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)i).build();
            for (Map.Entry<String, Object> map : data.get(i).entrySet()) {
                FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
                if (map.getValue() instanceof Collection) {
                    excelWriter.fill((Object)new FillWrapper(map.getKey(), (Collection)map.getValue()), fillConfig, writeSheet);
                    continue;
                }
                excelWriter.fill(map.getValue(), writeSheet);
            }
        }
        excelWriter.finish();
    }

    public static void resetResponse(String sheetName, HttpServletResponse response) throws UnsupportedEncodingException {
        String filename = ExcelUtil.encodingFilename(sheetName);
        FileUtils.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
    }

    public static String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)propertyValue, (CharSequence)separator)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String reverseByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)propertyValue, (CharSequence)separator)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[1].equals(value)) continue;
                    propertyString.append(itemArray[0] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[1].equals(propertyValue)) continue;
            return itemArray[0];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String encodingFilename(String filename) {
        return IdUtil.fastSimpleUUID() + "_" + filename + ".xlsx";
    }

    @Generated
    private ExcelUtil() {
    }
}

