/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.StreamUtils;
import cn.smarthse.framework.core.utils.ValidatorUtils;
import cn.smarthse.framework.excel.core.DefaultExcelResult;
import cn.smarthse.framework.excel.core.ExcelListener;
import cn.smarthse.framework.excel.core.ExcelResult;
import cn.smarthse.framework.json.utils.JsonUtils;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelDataConvertException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelListener<T>
extends AnalysisEventListener<T>
implements ExcelListener<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelListener.class);
    private Boolean isValidate = Boolean.TRUE;
    private Map<Integer, String> headMap;
    private ExcelResult<T> excelResult;

    public DefaultExcelListener(boolean isValidate) {
        this.excelResult = new DefaultExcelResult();
        this.isValidate = isValidate;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        String errMsg = null;
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            Integer rowIndex = excelDataConvertException.getRowIndex();
            Integer columnIndex = excelDataConvertException.getColumnIndex();
            errMsg = StrUtil.format((CharSequence)"\u7b2c{}\u884c-\u7b2c{}\u5217-\u8868\u5934{}: \u89e3\u6790\u5f02\u5e38<br/>", (Object[])new Object[]{rowIndex + 1, columnIndex + 1, this.headMap.get(columnIndex)});
            if (log.isDebugEnabled()) {
                log.error(errMsg);
            }
        }
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)exception;
            Set constraintViolations = constraintViolationException.getConstraintViolations();
            String constraintViolationsMsg = StreamUtils.join((Collection)constraintViolations, ConstraintViolation::getMessage, (CharSequence)", ");
            errMsg = StrUtil.format((CharSequence)"\u7b2c{}\u884c\u6570\u636e\u6821\u9a8c\u5f02\u5e38: {}", (Object[])new Object[]{context.readRowHolder().getRowIndex() + 1, constraintViolationsMsg});
            if (log.isDebugEnabled()) {
                log.error(errMsg);
            }
        }
        this.excelResult.getErrorList().add(errMsg);
        throw new ExcelAnalysisException(errMsg);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.headMap = headMap;
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u8868\u5934\u6570\u636e: {}", (Object)JsonUtils.toJsonString(headMap));
    }

    public void invoke(T data, AnalysisContext context) {
        if (this.isValidate.booleanValue()) {
            ValidatorUtils.validate(data, (Class[])new Class[0]);
        }
        this.excelResult.getList().add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    @Override
    public ExcelResult<T> getExcelResult() {
        return this.excelResult;
    }

    @Generated
    public DefaultExcelListener() {
    }
}

