/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.ReflectUtils;
import cn.smarthse.framework.excel.annotation.CellMerge;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellMergeHandler {
    private final boolean hasTitle;
    private int rowIndex;

    private CellMergeHandler(boolean hasTitle) {
        this.hasTitle = hasTitle;
        this.rowIndex = hasTitle ? 1 : 0;
    }

    private CellMergeHandler(boolean hasTitle, int rowIndex) {
        this.hasTitle = hasTitle;
        this.rowIndex = hasTitle ? rowIndex : 0;
    }

    public List<CellRangeAddress> handle(List<?> rows) {
        if (CollUtil.isEmpty(rows)) {
            return Collections.emptyList();
        }
        Map<Field, FieldColumnIndex> mergeFields = this.getFieldColumnIndexMap(rows.get(0).getClass());
        if (CollUtil.isEmpty(mergeFields)) {
            return Collections.emptyList();
        }
        ArrayList<CellRangeAddress> result = new ArrayList<CellRangeAddress>();
        HashMap<Field, RepeatCell> rowRepeatCellMap = new HashMap<Field, RepeatCell>();
        for (Map.Entry<Field, FieldColumnIndex> item : mergeFields.entrySet()) {
            Field field = item.getKey();
            FieldColumnIndex itemValue = item.getValue();
            int colNum = itemValue.colIndex();
            CellMerge cellMerge = itemValue.cellMerge();
            for (int i = 0; i < rows.size(); ++i) {
                Object currentRowObj = rows.get(i);
                Object currentRowObjFieldVal = ReflectUtils.invokeGetter(currentRowObj, (String)field.getName());
                if (currentRowObjFieldVal == null || "".equals(currentRowObjFieldVal)) continue;
                if (!rowRepeatCellMap.containsKey(field)) {
                    rowRepeatCellMap.put(field, RepeatCell.of(currentRowObjFieldVal, i));
                    continue;
                }
                RepeatCell repeatCell = (RepeatCell)rowRepeatCellMap.get(field);
                Object cellValue = repeatCell.value();
                int current = repeatCell.current();
                boolean merge = this.isMerge(currentRowObj, rows.get(i - 1), cellMerge);
                boolean isAddResult = false;
                int lastRow = i + this.rowIndex - 1;
                if (!currentRowObjFieldVal.equals(cellValue) || !merge) {
                    rowRepeatCellMap.put(field, RepeatCell.of(currentRowObjFieldVal, i));
                    isAddResult = true;
                }
                if (i == rows.size() - 1) {
                    isAddResult = true;
                    if (i > current) {
                        lastRow = i + this.rowIndex;
                    }
                }
                if (!isAddResult || i <= current || current + this.rowIndex == lastRow) continue;
                result.add(new CellRangeAddress(current + this.rowIndex, lastRow, colNum, colNum));
            }
        }
        return result;
    }

    private Map<Field, FieldColumnIndex> getFieldColumnIndexMap(Class<?> clazz) {
        boolean annotationPresent = clazz.isAnnotationPresent(ExcelIgnoreUnannotated.class);
        Field[] fields = ReflectUtils.getFields(clazz, field -> {
            if ("serialVersionUID".equals(field.getName())) {
                return false;
            }
            if (field.isAnnotationPresent(ExcelIgnore.class)) {
                return false;
            }
            return !annotationPresent || field.isAnnotationPresent(ExcelProperty.class);
        });
        HashMap<Field, FieldColumnIndex> mergeFields = new HashMap<Field, FieldColumnIndex>();
        for (int i = 0; i < fields.length; ++i) {
            Field field2 = fields[i];
            if (!field2.isAnnotationPresent(CellMerge.class)) continue;
            CellMerge cm = field2.getAnnotation(CellMerge.class);
            int index = cm.index() == -1 ? i : cm.index();
            mergeFields.put(field2, FieldColumnIndex.of(index, cm));
            if (!this.hasTitle) continue;
            ExcelProperty property = field2.getAnnotation(ExcelProperty.class);
            this.rowIndex = Math.max(this.rowIndex, property.value().length);
        }
        return mergeFields;
    }

    private boolean isMerge(Object currentRow, Object preRow, CellMerge cellMerge) {
        CharSequence[] mergeBy = cellMerge.mergeBy();
        if (StrUtil.isAllNotBlank((CharSequence[])mergeBy)) {
            for (CharSequence fieldName : mergeBy) {
                Object valCurrent = ReflectUtil.getFieldValue((Object)currentRow, (String)fieldName);
                Object valPre = ReflectUtil.getFieldValue((Object)preRow, (String)fieldName);
                if (Objects.equals(valPre, valCurrent)) continue;
                return false;
            }
        }
        return true;
    }

    public static CellMergeHandler of(boolean hasTitle, int rowIndex) {
        return new CellMergeHandler(hasTitle, rowIndex);
    }

    public static CellMergeHandler of(boolean hasTitle) {
        return new CellMergeHandler(hasTitle);
    }

    public static CellMergeHandler of() {
        return new CellMergeHandler(false);
    }

    record FieldColumnIndex(int colIndex, CellMerge cellMerge) {
        static FieldColumnIndex of(int colIndex, CellMerge cellMerge) {
            return new FieldColumnIndex(colIndex, cellMerge);
        }
    }

    record RepeatCell(Object value, int current) {
        static RepeatCell of(Object value, int current) {
            return new RepeatCell(value, current);
        }
    }
}

