/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.core;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.excel.core.CellMergeHandler;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.WorkbookWriteHandler;
import com.alibaba.excel.write.handler.context.WorkbookWriteHandlerContext;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.util.List;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellMergeStrategy
extends AbstractMergeStrategy
implements WorkbookWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CellMergeStrategy.class);
    private final List<CellRangeAddress> cellList;

    public CellMergeStrategy(List<CellRangeAddress> cellList) {
        this.cellList = cellList;
    }

    public CellMergeStrategy(List<?> list, boolean hasTitle) {
        this.cellList = CellMergeHandler.of(hasTitle).handle(list);
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        if (CollUtil.isEmpty(this.cellList)) {
            return;
        }
        int rowIndex = cell.getRowIndex();
        for (CellRangeAddress cellAddresses : this.cellList) {
            int firstRow = cellAddresses.getFirstRow();
            if (!cellAddresses.isInRange(cell) || rowIndex == firstRow) continue;
            cell.setBlank();
        }
    }

    public void afterWorkbookDispose(WorkbookWriteHandlerContext context) {
        if (CollUtil.isEmpty(this.cellList)) {
            return;
        }
        for (CellRangeAddress item : this.cellList) {
            context.getWriteContext().writeSheetHolder().getSheet().addMergedRegion(item);
        }
    }
}

