/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.excel.convert;

import cn.smarthse.framework.excel.utils.ExcelUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;

public class ExcelBigDecimalConverter
implements Converter<BigDecimal> {
    public Class<?> supportJavaTypeKey() {
        return BigDecimal.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public BigDecimal convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        try {
            String stringValue = cellData.getStringValue();
            if (stringValue == null || stringValue.trim().isEmpty() || "null".equalsIgnoreCase(stringValue.trim())) {
                return cellData.getOriginalNumberValue();
            }
            return new BigDecimal(stringValue.trim());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("%s\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u6570\u5b57\u683c\u5f0f", contentProperty == null ? "\u672a\u77e5\u5217" : "\u7b2c" + ExcelUtil.getExcelColName(cellData.getColumnIndex() + 1) + "\u5217"));
        }
    }

    public WriteCellData<?> convertToExcelData(BigDecimal value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return new WriteCellData(value != null ? value.toString() : "");
    }
}

