/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.framework.encrypt.filter;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.utils.EncryptUtils;
import cn.smarthse.framework.encrypt.domain.EncryptParam;
import cn.smarthse.framework.json.utils.JsonUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptRequestBodyWrapper
extends HttpServletRequestWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyWrapper.class);
    private final byte[] body;

    public DecryptRequestBodyWrapper(HttpServletRequest request, String privateKey, String headerFlag) throws IOException {
        super(request);
        String sm4Password;
        String encryptPassword = request.getHeader(headerFlag);
        try {
            String decryptSm4 = EncryptUtils.decryptBySm2((String)encryptPassword, (String)privateKey);
            sm4Password = EncryptUtils.decryptByBase64((String)decryptSm4);
        }
        catch (Exception e) {
            log.error("\u79d8\u94a5\u89e3\u5bc6\u5931\u8d25\uff01encryptPassword:{} privateKey:{}", new Object[]{encryptPassword, privateKey, e});
            throw new ServiceException("\u79d8\u94a5\u89e3\u5bc6\u5931\u8d25\uff01");
        }
        request.setCharacterEncoding("UTF-8");
        byte[] readBytes = IoUtil.readBytes((InputStream)request.getInputStream(), (boolean)false);
        String requestBody = new String(readBytes, StandardCharsets.UTF_8);
        EncryptParam encryptParam = (EncryptParam)JsonUtils.parseObject((String)requestBody, EncryptParam.class);
        if (Objects.isNull(encryptParam) || StrUtil.isBlank((CharSequence)encryptParam.getData())) {
            throw new ServiceException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff01");
        }
        String decryptBody = EncryptUtils.decryptBySm4((String)encryptParam.getData(), (String)sm4Password);
        this.body = decryptBody.getBytes(StandardCharsets.UTF_8);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public int getContentLength() {
        return this.body.length;
    }

    public long getContentLengthLong() {
        return this.body.length;
    }

    public String getContentType() {
        return "application/json";
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return bais.read();
            }

            public int available() {
                return DecryptRequestBodyWrapper.this.body.length;
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

